package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait ComputeStatus {
  def unwrap: software.amazon.awssdk.services.gamelift.model.ComputeStatus
}
object ComputeStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.ComputeStatus
  ): zio.aws.gamelift.model.ComputeStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.ComputeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.ComputeStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.gamelift.model.ComputeStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.gamelift.model.ComputeStatus.TERMINATING =>
      val r = TERMINATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.ComputeStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComputeStatus =
      software.amazon.awssdk.services.gamelift.model.ComputeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.gamelift.model.ComputeStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComputeStatus =
      software.amazon.awssdk.services.gamelift.model.ComputeStatus.PENDING
  }
  case object ACTIVE extends zio.aws.gamelift.model.ComputeStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComputeStatus =
      software.amazon.awssdk.services.gamelift.model.ComputeStatus.ACTIVE
  }
  case object TERMINATING extends zio.aws.gamelift.model.ComputeStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComputeStatus =
      software.amazon.awssdk.services.gamelift.model.ComputeStatus.TERMINATING
  }
}
