package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait ComputeType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.ComputeType
}
object ComputeType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.ComputeType
  ): zio.aws.gamelift.model.ComputeType = value match {
    case software.amazon.awssdk.services.gamelift.model.ComputeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.ComputeType.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.gamelift.model.ComputeType.ANYWHERE =>
      val r = ANYWHERE
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComputeType =
      software.amazon.awssdk.services.gamelift.model.ComputeType.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.gamelift.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComputeType =
      software.amazon.awssdk.services.gamelift.model.ComputeType.EC2
  }
  case object ANYWHERE extends zio.aws.gamelift.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ComputeType =
      software.amazon.awssdk.services.gamelift.model.ComputeType.ANYWHERE
  }
}
