package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.CustomLocationNameOrArnModel
import scala.jdk.CollectionConverters._
final case class DeleteLocationRequest(
    locationName: CustomLocationNameOrArnModel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest = {
    import DeleteLocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest
      .builder()
      .locationName(
        CustomLocationNameOrArnModel.unwrap(locationName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DeleteLocationRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteLocationRequest.wrap(buildAwsValue())
}
object DeleteLocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteLocationRequest =
      zio.aws.gamelift.model.DeleteLocationRequest(locationName)
    def locationName: CustomLocationNameOrArnModel
    def getLocationName: ZIO[Any, Nothing, CustomLocationNameOrArnModel] =
      ZIO.succeed(locationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest
  ) extends zio.aws.gamelift.model.DeleteLocationRequest.ReadOnly {
    override val locationName: CustomLocationNameOrArnModel =
      zio.aws.gamelift.model.primitives
        .CustomLocationNameOrArnModel(impl.locationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest
  ): zio.aws.gamelift.model.DeleteLocationRequest.ReadOnly = new Wrapper(impl)
}
