package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.MatchmakingRuleSetName
import scala.jdk.CollectionConverters._
final case class DeleteMatchmakingRuleSetRequest(name: MatchmakingRuleSetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest = {
    import DeleteMatchmakingRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest
      .builder()
      .name(MatchmakingRuleSetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest.ReadOnly =
    zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest.wrap(buildAwsValue())
}
object DeleteMatchmakingRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest =
      zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest(name)
    def name: MatchmakingRuleSetName
    def getName: ZIO[Any, Nothing, MatchmakingRuleSetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest
  ) extends zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest.ReadOnly {
    override val name: MatchmakingRuleSetName =
      zio.aws.gamelift.model.primitives.MatchmakingRuleSetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest
  ): zio.aws.gamelift.model.DeleteMatchmakingRuleSetRequest.ReadOnly =
    new Wrapper(impl)
}
