package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeFleetAttributesResponse(
    fleetAttributes: Optional[
      Iterable[zio.aws.gamelift.model.FleetAttributes]
    ] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse = {
    import DescribeFleetAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse
      .builder()
      .optionallyWith(
        fleetAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetAttributes)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetAttributesResponse.wrap(buildAwsValue())
}
object DescribeFleetAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetAttributesResponse =
      zio.aws.gamelift.model.DescribeFleetAttributesResponse(
        fleetAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetAttributes
        : Optional[List[zio.aws.gamelift.model.FleetAttributes.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetAttributes: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.FleetAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetAttributes", fleetAttributes)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse
  ) extends zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly {
    override val fleetAttributes
        : Optional[List[zio.aws.gamelift.model.FleetAttributes.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.FleetAttributes.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse
  ): zio.aws.gamelift.model.DescribeFleetAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
