package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  FleetArn,
  FleetId
}
import scala.jdk.CollectionConverters._
final case class DescribeFleetPortSettingsResponse(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    inboundPermissions: Optional[
      Iterable[zio.aws.gamelift.model.IpPermission]
    ] = Optional.Absent,
    updateStatus: Optional[zio.aws.gamelift.model.LocationUpdateStatus] =
      Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse = {
    import DescribeFleetPortSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        inboundPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inboundPermissions)
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetPortSettingsResponse
      .wrap(buildAwsValue())
}
object DescribeFleetPortSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetPortSettingsResponse =
      zio.aws.gamelift.model.DescribeFleetPortSettingsResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        inboundPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateStatus.map(value => value),
        location.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def inboundPermissions
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]]
    def updateStatus: Optional[zio.aws.gamelift.model.LocationUpdateStatus]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getInboundPermissions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.IpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("inboundPermissions", inboundPermissions)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.LocationUpdateStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse
  ) extends zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val inboundPermissions
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.IpPermission.wrap(item)
          }.toList
        )
    override val updateStatus
        : Optional[zio.aws.gamelift.model.LocationUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateStatus())
        .map(value => zio.aws.gamelift.model.LocationUpdateStatus.wrap(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse
  ): zio.aws.gamelift.model.DescribeFleetPortSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
