package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeFleetUtilizationResponse(
    fleetUtilization: Optional[
      Iterable[zio.aws.gamelift.model.FleetUtilization]
    ] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse = {
    import DescribeFleetUtilizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse
      .builder()
      .optionallyWith(
        fleetUtilization.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetUtilization)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetUtilizationResponse
      .wrap(buildAwsValue())
}
object DescribeFleetUtilizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetUtilizationResponse =
      zio.aws.gamelift.model.DescribeFleetUtilizationResponse(
        fleetUtilization.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetUtilization
        : Optional[List[zio.aws.gamelift.model.FleetUtilization.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetUtilization: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.FleetUtilization.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetUtilization", fleetUtilization)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse
  ) extends zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly {
    override val fleetUtilization
        : Optional[List[zio.aws.gamelift.model.FleetUtilization.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetUtilization())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.FleetUtilization.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse
  ): zio.aws.gamelift.model.DescribeFleetUtilizationResponse.ReadOnly =
    new Wrapper(impl)
}
