package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionQueuesResponse(
    gameSessionQueues: Optional[
      Iterable[zio.aws.gamelift.model.GameSessionQueue]
    ] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse = {
    import DescribeGameSessionQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse
      .builder()
      .optionallyWith(
        gameSessionQueues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameSessionQueues)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionQueuesResponse
      .wrap(buildAwsValue())
}
object DescribeGameSessionQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionQueuesResponse =
      zio.aws.gamelift.model.DescribeGameSessionQueuesResponse(
        gameSessionQueues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gameSessionQueues
        : Optional[List[zio.aws.gamelift.model.GameSessionQueue.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getGameSessionQueues: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameSessionQueue.ReadOnly
    ]] = AwsError.unwrapOptionField("gameSessionQueues", gameSessionQueues)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse
  ) extends zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly {
    override val gameSessionQueues
        : Optional[List[zio.aws.gamelift.model.GameSessionQueue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionQueues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameSessionQueue.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse
  ): zio.aws.gamelift.model.DescribeGameSessionQueuesResponse.ReadOnly =
    new Wrapper(impl)
}
