package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionsResponse(
    gameSessions: Optional[Iterable[zio.aws.gamelift.model.GameSession]] =
      Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse = {
    import DescribeGameSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse
      .builder()
      .optionallyWith(
        gameSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameSessions)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionsResponse.wrap(buildAwsValue())
}
object DescribeGameSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionsResponse =
      zio.aws.gamelift.model.DescribeGameSessionsResponse(
        gameSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gameSessions
        : Optional[List[zio.aws.gamelift.model.GameSession.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getGameSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameSession.ReadOnly
    ]] = AwsError.unwrapOptionField("gameSessions", gameSessions)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse
  ) extends zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly {
    override val gameSessions
        : Optional[List[zio.aws.gamelift.model.GameSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameSession.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse
  ): zio.aws.gamelift.model.DescribeGameSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
