package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribePlayerSessionsResponse(
    playerSessions: Optional[Iterable[zio.aws.gamelift.model.PlayerSession]] =
      Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse = {
    import DescribePlayerSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse
      .builder()
      .optionallyWith(
        playerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerSessions)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribePlayerSessionsResponse.wrap(buildAwsValue())
}
object DescribePlayerSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribePlayerSessionsResponse =
      zio.aws.gamelift.model.DescribePlayerSessionsResponse(
        playerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def playerSessions
        : Optional[List[zio.aws.gamelift.model.PlayerSession.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerSession.ReadOnly
    ]] = AwsError.unwrapOptionField("playerSessions", playerSessions)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse
  ) extends zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly {
    override val playerSessions
        : Optional[List[zio.aws.gamelift.model.PlayerSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PlayerSession.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse
  ): zio.aws.gamelift.model.DescribePlayerSessionsResponse.ReadOnly =
    new Wrapper(impl)
}
