package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcPeeringConnectionsResponse(
    vpcPeeringConnections: Optional[
      Iterable[zio.aws.gamelift.model.VpcPeeringConnection]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse = {
    import DescribeVpcPeeringConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse
      .builder()
      .optionallyWith(
        vpcPeeringConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcPeeringConnections)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcPeeringConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse =
      zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse(
        vpcPeeringConnections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcPeeringConnections
        : Optional[List[zio.aws.gamelift.model.VpcPeeringConnection.ReadOnly]]
    def getVpcPeeringConnections: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.VpcPeeringConnection.ReadOnly
    ]] =
      AwsError.unwrapOptionField("vpcPeeringConnections", vpcPeeringConnections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse
  ) extends zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly {
    override val vpcPeeringConnections
        : Optional[List[zio.aws.gamelift.model.VpcPeeringConnection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.VpcPeeringConnection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse
  ): zio.aws.gamelift.model.DescribeVpcPeeringConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
