package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait EC2InstanceType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.EC2InstanceType
}
object EC2InstanceType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.EC2InstanceType
  ): zio.aws.gamelift.model.EC2InstanceType = value match {
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_MICRO =>
      val r = `t2.micro`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_SMALL =>
      val r = `t2.small`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_MEDIUM =>
      val r = `t2.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_LARGE =>
      val r = `t2.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_LARGE =>
      val r = `c3.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_XLARGE =>
      val r = `c3.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_2_XLARGE =>
      val r = `c3.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_4_XLARGE =>
      val r = `c3.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_8_XLARGE =>
      val r = `c3.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_LARGE =>
      val r = `c4.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_XLARGE =>
      val r = `c4.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_2_XLARGE =>
      val r = `c4.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_4_XLARGE =>
      val r = `c4.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_8_XLARGE =>
      val r = `c4.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_LARGE =>
      val r = `c5.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_XLARGE =>
      val r = `c5.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_2_XLARGE =>
      val r = `c5.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_4_XLARGE =>
      val r = `c5.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_9_XLARGE =>
      val r = `c5.9xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_12_XLARGE =>
      val r = `c5.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_18_XLARGE =>
      val r = `c5.18xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_24_XLARGE =>
      val r = `c5.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_LARGE =>
      val r = `c5a.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_XLARGE =>
      val r = `c5a.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_2_XLARGE =>
      val r = `c5a.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_4_XLARGE =>
      val r = `c5a.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_8_XLARGE =>
      val r = `c5a.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_12_XLARGE =>
      val r = `c5a.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_16_XLARGE =>
      val r = `c5a.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_24_XLARGE =>
      val r = `c5a.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_LARGE =>
      val r = `r3.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_XLARGE =>
      val r = `r3.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_2_XLARGE =>
      val r = `r3.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_4_XLARGE =>
      val r = `r3.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_8_XLARGE =>
      val r = `r3.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_LARGE =>
      val r = `r4.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_XLARGE =>
      val r = `r4.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_2_XLARGE =>
      val r = `r4.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_4_XLARGE =>
      val r = `r4.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_8_XLARGE =>
      val r = `r4.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_16_XLARGE =>
      val r = `r4.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_LARGE =>
      val r = `r5.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_XLARGE =>
      val r = `r5.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_2_XLARGE =>
      val r = `r5.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_4_XLARGE =>
      val r = `r5.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_8_XLARGE =>
      val r = `r5.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_12_XLARGE =>
      val r = `r5.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_16_XLARGE =>
      val r = `r5.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_24_XLARGE =>
      val r = `r5.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_LARGE =>
      val r = `r5a.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_XLARGE =>
      val r = `r5a.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_2_XLARGE =>
      val r = `r5a.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_4_XLARGE =>
      val r = `r5a.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_8_XLARGE =>
      val r = `r5a.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_12_XLARGE =>
      val r = `r5a.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_16_XLARGE =>
      val r = `r5a.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_24_XLARGE =>
      val r = `r5a.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_MEDIUM =>
      val r = `m3.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_LARGE =>
      val r = `m3.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_XLARGE =>
      val r = `m3.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_2_XLARGE =>
      val r = `m3.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_LARGE =>
      val r = `m4.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_XLARGE =>
      val r = `m4.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_2_XLARGE =>
      val r = `m4.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_4_XLARGE =>
      val r = `m4.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_10_XLARGE =>
      val r = `m4.10xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_LARGE =>
      val r = `m5.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_XLARGE =>
      val r = `m5.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_2_XLARGE =>
      val r = `m5.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_4_XLARGE =>
      val r = `m5.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_8_XLARGE =>
      val r = `m5.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_12_XLARGE =>
      val r = `m5.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_16_XLARGE =>
      val r = `m5.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_24_XLARGE =>
      val r = `m5.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_LARGE =>
      val r = `m5a.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_XLARGE =>
      val r = `m5a.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_2_XLARGE =>
      val r = `m5a.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_4_XLARGE =>
      val r = `m5a.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_8_XLARGE =>
      val r = `m5a.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_12_XLARGE =>
      val r = `m5a.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_16_XLARGE =>
      val r = `m5a.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_24_XLARGE =>
      val r = `m5a.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_LARGE =>
      val r = `c5d.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_XLARGE =>
      val r = `c5d.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_2_XLARGE =>
      val r = `c5d.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_4_XLARGE =>
      val r = `c5d.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_9_XLARGE =>
      val r = `c5d.9xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_12_XLARGE =>
      val r = `c5d.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_18_XLARGE =>
      val r = `c5d.18xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_24_XLARGE =>
      val r = `c5d.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_LARGE =>
      val r = `c6a.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_XLARGE =>
      val r = `c6a.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_2_XLARGE =>
      val r = `c6a.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_4_XLARGE =>
      val r = `c6a.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_8_XLARGE =>
      val r = `c6a.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_12_XLARGE =>
      val r = `c6a.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_16_XLARGE =>
      val r = `c6a.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_24_XLARGE =>
      val r = `c6a.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_LARGE =>
      val r = `c6i.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_XLARGE =>
      val r = `c6i.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_2_XLARGE =>
      val r = `c6i.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_4_XLARGE =>
      val r = `c6i.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_8_XLARGE =>
      val r = `c6i.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_12_XLARGE =>
      val r = `c6i.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_16_XLARGE =>
      val r = `c6i.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_24_XLARGE =>
      val r = `c6i.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_LARGE =>
      val r = `r5d.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_XLARGE =>
      val r = `r5d.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_2_XLARGE =>
      val r = `r5d.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_4_XLARGE =>
      val r = `r5d.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_8_XLARGE =>
      val r = `r5d.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_12_XLARGE =>
      val r = `r5d.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_16_XLARGE =>
      val r = `r5d.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_24_XLARGE =>
      val r = `r5d.24xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_MEDIUM =>
      val r = `m6g.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_LARGE =>
      val r = `m6g.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_XLARGE =>
      val r = `m6g.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_2_XLARGE =>
      val r = `m6g.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_4_XLARGE =>
      val r = `m6g.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_8_XLARGE =>
      val r = `m6g.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_12_XLARGE =>
      val r = `m6g.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_16_XLARGE =>
      val r = `m6g.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_MEDIUM =>
      val r = `c6g.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_LARGE =>
      val r = `c6g.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_XLARGE =>
      val r = `c6g.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_2_XLARGE =>
      val r = `c6g.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_4_XLARGE =>
      val r = `c6g.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_8_XLARGE =>
      val r = `c6g.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_12_XLARGE =>
      val r = `c6g.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_16_XLARGE =>
      val r = `c6g.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_MEDIUM =>
      val r = `r6g.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_LARGE =>
      val r = `r6g.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_XLARGE =>
      val r = `r6g.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_2_XLARGE =>
      val r = `r6g.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_4_XLARGE =>
      val r = `r6g.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_8_XLARGE =>
      val r = `r6g.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_12_XLARGE =>
      val r = `r6g.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_16_XLARGE =>
      val r = `r6g.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_MEDIUM =>
      val r = `c6gn.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_LARGE =>
      val r = `c6gn.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_XLARGE =>
      val r = `c6gn.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_2_XLARGE =>
      val r = `c6gn.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_4_XLARGE =>
      val r = `c6gn.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_8_XLARGE =>
      val r = `c6gn.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_12_XLARGE =>
      val r = `c6gn.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_16_XLARGE =>
      val r = `c6gn.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_MEDIUM =>
      val r = `c7g.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_LARGE =>
      val r = `c7g.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_XLARGE =>
      val r = `c7g.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_2_XLARGE =>
      val r = `c7g.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_4_XLARGE =>
      val r = `c7g.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_8_XLARGE =>
      val r = `c7g.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_12_XLARGE =>
      val r = `c7g.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_16_XLARGE =>
      val r = `c7g.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_MEDIUM =>
      val r = `r7g.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_LARGE =>
      val r = `r7g.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_XLARGE =>
      val r = `r7g.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_2_XLARGE =>
      val r = `r7g.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_4_XLARGE =>
      val r = `r7g.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_8_XLARGE =>
      val r = `r7g.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_12_XLARGE =>
      val r = `r7g.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_16_XLARGE =>
      val r = `r7g.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_MEDIUM =>
      val r = `m7g.medium`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_LARGE =>
      val r = `m7g.large`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_XLARGE =>
      val r = `m7g.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_2_XLARGE =>
      val r = `m7g.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_4_XLARGE =>
      val r = `m7g.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_8_XLARGE =>
      val r = `m7g.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_12_XLARGE =>
      val r = `m7g.12xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_16_XLARGE =>
      val r = `m7g.16xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_XLARGE =>
      val r = `g5g.xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_2_XLARGE =>
      val r = `g5g.2xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_4_XLARGE =>
      val r = `g5g.4xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_8_XLARGE =>
      val r = `g5g.8xlarge`
      r
    case software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_16_XLARGE =>
      val r = `g5g.16xlarge`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `t2.micro` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_MICRO
  }
  case object `t2.small` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_SMALL
  }
  case object `t2.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_MEDIUM
  }
  case object `t2.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.T2_LARGE
  }
  case object `c3.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_LARGE
  }
  case object `c3.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_XLARGE
  }
  case object `c3.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_2_XLARGE
  }
  case object `c3.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_4_XLARGE
  }
  case object `c3.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C3_8_XLARGE
  }
  case object `c4.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_LARGE
  }
  case object `c4.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_XLARGE
  }
  case object `c4.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_2_XLARGE
  }
  case object `c4.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_4_XLARGE
  }
  case object `c4.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C4_8_XLARGE
  }
  case object `c5.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_LARGE
  }
  case object `c5.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_XLARGE
  }
  case object `c5.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_2_XLARGE
  }
  case object `c5.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_4_XLARGE
  }
  case object `c5.9xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_9_XLARGE
  }
  case object `c5.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_12_XLARGE
  }
  case object `c5.18xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_18_XLARGE
  }
  case object `c5.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_24_XLARGE
  }
  case object `c5a.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_LARGE
  }
  case object `c5a.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_XLARGE
  }
  case object `c5a.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_2_XLARGE
  }
  case object `c5a.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_4_XLARGE
  }
  case object `c5a.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_8_XLARGE
  }
  case object `c5a.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_12_XLARGE
  }
  case object `c5a.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_16_XLARGE
  }
  case object `c5a.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_A_24_XLARGE
  }
  case object `r3.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_LARGE
  }
  case object `r3.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_XLARGE
  }
  case object `r3.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_2_XLARGE
  }
  case object `r3.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_4_XLARGE
  }
  case object `r3.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R3_8_XLARGE
  }
  case object `r4.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_LARGE
  }
  case object `r4.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_XLARGE
  }
  case object `r4.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_2_XLARGE
  }
  case object `r4.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_4_XLARGE
  }
  case object `r4.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_8_XLARGE
  }
  case object `r4.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R4_16_XLARGE
  }
  case object `r5.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_LARGE
  }
  case object `r5.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_XLARGE
  }
  case object `r5.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_2_XLARGE
  }
  case object `r5.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_4_XLARGE
  }
  case object `r5.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_8_XLARGE
  }
  case object `r5.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_12_XLARGE
  }
  case object `r5.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_16_XLARGE
  }
  case object `r5.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_24_XLARGE
  }
  case object `r5a.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_LARGE
  }
  case object `r5a.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_XLARGE
  }
  case object `r5a.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_2_XLARGE
  }
  case object `r5a.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_4_XLARGE
  }
  case object `r5a.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_8_XLARGE
  }
  case object `r5a.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_12_XLARGE
  }
  case object `r5a.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_16_XLARGE
  }
  case object `r5a.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_A_24_XLARGE
  }
  case object `m3.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_MEDIUM
  }
  case object `m3.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_LARGE
  }
  case object `m3.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_XLARGE
  }
  case object `m3.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M3_2_XLARGE
  }
  case object `m4.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_LARGE
  }
  case object `m4.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_XLARGE
  }
  case object `m4.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_2_XLARGE
  }
  case object `m4.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_4_XLARGE
  }
  case object `m4.10xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M4_10_XLARGE
  }
  case object `m5.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_LARGE
  }
  case object `m5.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_XLARGE
  }
  case object `m5.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_2_XLARGE
  }
  case object `m5.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_4_XLARGE
  }
  case object `m5.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_8_XLARGE
  }
  case object `m5.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_12_XLARGE
  }
  case object `m5.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_16_XLARGE
  }
  case object `m5.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_24_XLARGE
  }
  case object `m5a.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_LARGE
  }
  case object `m5a.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_XLARGE
  }
  case object `m5a.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_2_XLARGE
  }
  case object `m5a.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_4_XLARGE
  }
  case object `m5a.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_8_XLARGE
  }
  case object `m5a.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_12_XLARGE
  }
  case object `m5a.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_16_XLARGE
  }
  case object `m5a.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M5_A_24_XLARGE
  }
  case object `c5d.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_LARGE
  }
  case object `c5d.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_XLARGE
  }
  case object `c5d.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_2_XLARGE
  }
  case object `c5d.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_4_XLARGE
  }
  case object `c5d.9xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_9_XLARGE
  }
  case object `c5d.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_12_XLARGE
  }
  case object `c5d.18xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_18_XLARGE
  }
  case object `c5d.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C5_D_24_XLARGE
  }
  case object `c6a.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_LARGE
  }
  case object `c6a.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_XLARGE
  }
  case object `c6a.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_2_XLARGE
  }
  case object `c6a.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_4_XLARGE
  }
  case object `c6a.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_8_XLARGE
  }
  case object `c6a.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_12_XLARGE
  }
  case object `c6a.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_16_XLARGE
  }
  case object `c6a.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_A_24_XLARGE
  }
  case object `c6i.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_LARGE
  }
  case object `c6i.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_XLARGE
  }
  case object `c6i.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_2_XLARGE
  }
  case object `c6i.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_4_XLARGE
  }
  case object `c6i.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_8_XLARGE
  }
  case object `c6i.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_12_XLARGE
  }
  case object `c6i.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_16_XLARGE
  }
  case object `c6i.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_I_24_XLARGE
  }
  case object `r5d.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_LARGE
  }
  case object `r5d.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_XLARGE
  }
  case object `r5d.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_2_XLARGE
  }
  case object `r5d.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_4_XLARGE
  }
  case object `r5d.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_8_XLARGE
  }
  case object `r5d.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_12_XLARGE
  }
  case object `r5d.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_16_XLARGE
  }
  case object `r5d.24xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R5_D_24_XLARGE
  }
  case object `m6g.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_MEDIUM
  }
  case object `m6g.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_LARGE
  }
  case object `m6g.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_XLARGE
  }
  case object `m6g.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_2_XLARGE
  }
  case object `m6g.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_4_XLARGE
  }
  case object `m6g.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_8_XLARGE
  }
  case object `m6g.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_12_XLARGE
  }
  case object `m6g.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M6_G_16_XLARGE
  }
  case object `c6g.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_MEDIUM
  }
  case object `c6g.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_LARGE
  }
  case object `c6g.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_XLARGE
  }
  case object `c6g.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_2_XLARGE
  }
  case object `c6g.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_4_XLARGE
  }
  case object `c6g.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_8_XLARGE
  }
  case object `c6g.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_12_XLARGE
  }
  case object `c6g.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_G_16_XLARGE
  }
  case object `r6g.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_MEDIUM
  }
  case object `r6g.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_LARGE
  }
  case object `r6g.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_XLARGE
  }
  case object `r6g.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_2_XLARGE
  }
  case object `r6g.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_4_XLARGE
  }
  case object `r6g.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_8_XLARGE
  }
  case object `r6g.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_12_XLARGE
  }
  case object `r6g.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R6_G_16_XLARGE
  }
  case object `c6gn.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_MEDIUM
  }
  case object `c6gn.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_LARGE
  }
  case object `c6gn.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_XLARGE
  }
  case object `c6gn.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_2_XLARGE
  }
  case object `c6gn.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_4_XLARGE
  }
  case object `c6gn.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_8_XLARGE
  }
  case object `c6gn.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_12_XLARGE
  }
  case object `c6gn.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C6_GN_16_XLARGE
  }
  case object `c7g.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_MEDIUM
  }
  case object `c7g.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_LARGE
  }
  case object `c7g.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_XLARGE
  }
  case object `c7g.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_2_XLARGE
  }
  case object `c7g.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_4_XLARGE
  }
  case object `c7g.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_8_XLARGE
  }
  case object `c7g.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_12_XLARGE
  }
  case object `c7g.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.C7_G_16_XLARGE
  }
  case object `r7g.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_MEDIUM
  }
  case object `r7g.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_LARGE
  }
  case object `r7g.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_XLARGE
  }
  case object `r7g.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_2_XLARGE
  }
  case object `r7g.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_4_XLARGE
  }
  case object `r7g.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_8_XLARGE
  }
  case object `r7g.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_12_XLARGE
  }
  case object `r7g.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.R7_G_16_XLARGE
  }
  case object `m7g.medium` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_MEDIUM
  }
  case object `m7g.large` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_LARGE
  }
  case object `m7g.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_XLARGE
  }
  case object `m7g.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_2_XLARGE
  }
  case object `m7g.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_4_XLARGE
  }
  case object `m7g.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_8_XLARGE
  }
  case object `m7g.12xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_12_XLARGE
  }
  case object `m7g.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.M7_G_16_XLARGE
  }
  case object `g5g.xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_XLARGE
  }
  case object `g5g.2xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_2_XLARGE
  }
  case object `g5g.4xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_4_XLARGE
  }
  case object `g5g.8xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_8_XLARGE
  }
  case object `g5g.16xlarge` extends zio.aws.gamelift.model.EC2InstanceType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EC2InstanceType =
      software.amazon.awssdk.services.gamelift.model.EC2InstanceType.G5_G_16_XLARGE
  }
}
