package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  Timestamp,
  NonEmptyString,
  NonZeroAndMaxString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Event(
    eventId: Optional[NonZeroAndMaxString] = Optional.Absent,
    resourceId: Optional[NonZeroAndMaxString] = Optional.Absent,
    eventCode: Optional[zio.aws.gamelift.model.EventCode] = Optional.Absent,
    message: Optional[NonEmptyString] = Optional.Absent,
    eventTime: Optional[Timestamp] = Optional.Absent,
    preSignedLogUrl: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Event
      .builder()
      .optionallyWith(
        eventId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.eventId)
      .optionallyWith(
        resourceId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(eventCode.map(value => value.unwrap))(_.eventCode)
      .optionallyWith(
        message.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        preSignedLogUrl.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.preSignedLogUrl)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Event.ReadOnly =
    zio.aws.gamelift.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Event = zio.aws.gamelift.model.Event(
      eventId.map(value => value),
      resourceId.map(value => value),
      eventCode.map(value => value),
      message.map(value => value),
      eventTime.map(value => value),
      preSignedLogUrl.map(value => value)
    )
    def eventId: Optional[NonZeroAndMaxString]
    def resourceId: Optional[NonZeroAndMaxString]
    def eventCode: Optional[zio.aws.gamelift.model.EventCode]
    def message: Optional[NonEmptyString]
    def eventTime: Optional[Timestamp]
    def preSignedLogUrl: Optional[NonZeroAndMaxString]
    def getEventId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getResourceId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getEventCode: ZIO[Any, AwsError, zio.aws.gamelift.model.EventCode] =
      AwsError.unwrapOptionField("eventCode", eventCode)
    def getMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("message", message)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getPreSignedLogUrl: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("preSignedLogUrl", preSignedLogUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Event
  ) extends zio.aws.gamelift.model.Event.ReadOnly {
    override val eventId: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val resourceId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val eventCode: Optional[zio.aws.gamelift.model.EventCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCode())
        .map(value => zio.aws.gamelift.model.EventCode.wrap(value))
    override val message: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val eventTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val preSignedLogUrl: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preSignedLogUrl())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Event
  ): zio.aws.gamelift.model.Event.ReadOnly = new Wrapper(impl)
}
