package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  DnsName,
  PortNumber,
  MatchmakerData,
  GameSessionQueueName,
  WholeNumber,
  Timestamp,
  IpAddress,
  IdStringModel,
  LargeGameSessionData,
  NonZeroAndMaxString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GameSessionPlacement(
    placementId: Optional[IdStringModel] = Optional.Absent,
    gameSessionQueueName: Optional[GameSessionQueueName] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.GameSessionPlacementState] =
      Optional.Absent,
    gameProperties: Optional[Iterable[zio.aws.gamelift.model.GameProperty]] =
      Optional.Absent,
    maximumPlayerSessionCount: Optional[WholeNumber] = Optional.Absent,
    gameSessionName: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionId: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionArn: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionRegion: Optional[NonZeroAndMaxString] = Optional.Absent,
    playerLatencies: Optional[Iterable[zio.aws.gamelift.model.PlayerLatency]] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    dnsName: Optional[DnsName] = Optional.Absent,
    port: Optional[PortNumber] = Optional.Absent,
    placedPlayerSessions: Optional[
      Iterable[zio.aws.gamelift.model.PlacedPlayerSession]
    ] = Optional.Absent,
    gameSessionData: Optional[LargeGameSessionData] = Optional.Absent,
    matchmakerData: Optional[MatchmakerData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionPlacement = {
    import GameSessionPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
      .builder()
      .optionallyWith(
        placementId.map(value => IdStringModel.unwrap(value): java.lang.String)
      )(_.placementId)
      .optionallyWith(
        gameSessionQueueName.map(value =>
          GameSessionQueueName.unwrap(value): java.lang.String
        )
      )(_.gameSessionQueueName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        maximumPlayerSessionCount.map(value =>
          WholeNumber.unwrap(value): Integer
        )
      )(_.maximumPlayerSessionCount)
      .optionallyWith(
        gameSessionName.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionName)
      .optionallyWith(
        gameSessionId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        gameSessionArn.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionArn)
      .optionallyWith(
        gameSessionRegion.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionRegion)
      .optionallyWith(
        playerLatencies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playerLatencies)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(port.map(value => PortNumber.unwrap(value): Integer))(
        _.port
      )
      .optionallyWith(
        placedPlayerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placedPlayerSessions)
      .optionallyWith(
        gameSessionData.map(value =>
          LargeGameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(
        matchmakerData.map(value =>
          MatchmakerData.unwrap(value): java.lang.String
        )
      )(_.matchmakerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionPlacement.ReadOnly =
    zio.aws.gamelift.model.GameSessionPlacement.wrap(buildAwsValue())
}
object GameSessionPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionPlacement =
      zio.aws.gamelift.model.GameSessionPlacement(
        placementId.map(value => value),
        gameSessionQueueName.map(value => value),
        status.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maximumPlayerSessionCount.map(value => value),
        gameSessionName.map(value => value),
        gameSessionId.map(value => value),
        gameSessionArn.map(value => value),
        gameSessionRegion.map(value => value),
        playerLatencies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTime.map(value => value),
        endTime.map(value => value),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        port.map(value => value),
        placedPlayerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionData.map(value => value),
        matchmakerData.map(value => value)
      )
    def placementId: Optional[IdStringModel]
    def gameSessionQueueName: Optional[GameSessionQueueName]
    def status: Optional[zio.aws.gamelift.model.GameSessionPlacementState]
    def gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def maximumPlayerSessionCount: Optional[WholeNumber]
    def gameSessionName: Optional[NonZeroAndMaxString]
    def gameSessionId: Optional[NonZeroAndMaxString]
    def gameSessionArn: Optional[NonZeroAndMaxString]
    def gameSessionRegion: Optional[NonZeroAndMaxString]
    def playerLatencies
        : Optional[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def ipAddress: Optional[IpAddress]
    def dnsName: Optional[DnsName]
    def port: Optional[PortNumber]
    def placedPlayerSessions
        : Optional[List[zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly]]
    def gameSessionData: Optional[LargeGameSessionData]
    def matchmakerData: Optional[MatchmakerData]
    def getPlacementId: ZIO[Any, AwsError, IdStringModel] =
      AwsError.unwrapOptionField("placementId", placementId)
    def getGameSessionQueueName: ZIO[Any, AwsError, GameSessionQueueName] =
      AwsError.unwrapOptionField("gameSessionQueueName", gameSessionQueueName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSessionPlacementState] =
      AwsError.unwrapOptionField("status", status)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getMaximumPlayerSessionCount: ZIO[Any, AwsError, WholeNumber] = AwsError
      .unwrapOptionField("maximumPlayerSessionCount", maximumPlayerSessionCount)
    def getGameSessionName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionName", gameSessionName)
    def getGameSessionId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getGameSessionArn: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionArn", gameSessionArn)
    def getGameSessionRegion: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionRegion", gameSessionRegion)
    def getPlayerLatencies: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlayerLatency.ReadOnly
    ]] = AwsError.unwrapOptionField("playerLatencies", playerLatencies)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("port", port)
    def getPlacedPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placedPlayerSessions", placedPlayerSessions)
    def getGameSessionData: ZIO[Any, AwsError, LargeGameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getMatchmakerData: ZIO[Any, AwsError, MatchmakerData] =
      AwsError.unwrapOptionField("matchmakerData", matchmakerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
  ) extends zio.aws.gamelift.model.GameSessionPlacement.ReadOnly {
    override val placementId: Optional[IdStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.placementId())
      .map(value => zio.aws.gamelift.model.primitives.IdStringModel(value))
    override val gameSessionQueueName: Optional[GameSessionQueueName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionQueueName())
        .map(value =>
          zio.aws.gamelift.model.primitives.GameSessionQueueName(value)
        )
    override val status
        : Optional[zio.aws.gamelift.model.GameSessionPlacementState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.gamelift.model.GameSessionPlacementState.wrap(value)
        )
    override val gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameProperty.wrap(item)
          }.toList
        )
    override val maximumPlayerSessionCount: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumPlayerSessionCount())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val gameSessionName: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionName())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameSessionId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameSessionArn: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameSessionRegion: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionRegion())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val playerLatencies
        : Optional[List[zio.aws.gamelift.model.PlayerLatency.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerLatencies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PlayerLatency.wrap(item)
          }.toList
        )
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val dnsName: Optional[DnsName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val port: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.gamelift.model.primitives.PortNumber(value))
    override val placedPlayerSessions
        : Optional[List[zio.aws.gamelift.model.PlacedPlayerSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placedPlayerSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.PlacedPlayerSession.wrap(item)
          }.toList
        )
    override val gameSessionData: Optional[LargeGameSessionData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionData())
        .map(value =>
          zio.aws.gamelift.model.primitives.LargeGameSessionData(value)
        )
    override val matchmakerData: Optional[MatchmakerData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchmakerData())
        .map(value => zio.aws.gamelift.model.primitives.MatchmakerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionPlacement
  ): zio.aws.gamelift.model.GameSessionPlacement.ReadOnly = new Wrapper(impl)
}
