package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  FleetArn,
  ComputeNameOrArn,
  FleetIdOrArn,
  Timestamp,
  ComputeArn,
  ComputeAuthToken
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetComputeAuthTokenResponse(
    fleetId: Optional[FleetIdOrArn] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    computeName: Optional[ComputeNameOrArn] = Optional.Absent,
    computeArn: Optional[ComputeArn] = Optional.Absent,
    authToken: Optional[ComputeAuthToken] = Optional.Absent,
    expirationTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse = {
    import GetComputeAuthTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        computeName.map(value =>
          ComputeNameOrArn.unwrap(value): java.lang.String
        )
      )(_.computeName)
      .optionallyWith(
        computeArn.map(value => ComputeArn.unwrap(value): java.lang.String)
      )(_.computeArn)
      .optionallyWith(
        authToken.map(value => ComputeAuthToken.unwrap(value): java.lang.String)
      )(_.authToken)
      .optionallyWith(
        expirationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.expirationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GetComputeAuthTokenResponse.ReadOnly =
    zio.aws.gamelift.model.GetComputeAuthTokenResponse.wrap(buildAwsValue())
}
object GetComputeAuthTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GetComputeAuthTokenResponse =
      zio.aws.gamelift.model.GetComputeAuthTokenResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        computeName.map(value => value),
        computeArn.map(value => value),
        authToken.map(value => value),
        expirationTimestamp.map(value => value)
      )
    def fleetId: Optional[FleetIdOrArn]
    def fleetArn: Optional[FleetArn]
    def computeName: Optional[ComputeNameOrArn]
    def computeArn: Optional[ComputeArn]
    def authToken: Optional[ComputeAuthToken]
    def expirationTimestamp: Optional[Timestamp]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getComputeName: ZIO[Any, AwsError, ComputeNameOrArn] =
      AwsError.unwrapOptionField("computeName", computeName)
    def getComputeArn: ZIO[Any, AwsError, ComputeArn] =
      AwsError.unwrapOptionField("computeArn", computeArn)
    def getAuthToken: ZIO[Any, AwsError, ComputeAuthToken] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getExpirationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expirationTimestamp", expirationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse
  ) extends zio.aws.gamelift.model.GetComputeAuthTokenResponse.ReadOnly {
    override val fleetId: Optional[FleetIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val computeName: Optional[ComputeNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.computeName())
      .map(value => zio.aws.gamelift.model.primitives.ComputeNameOrArn(value))
    override val computeArn: Optional[ComputeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.computeArn())
      .map(value => zio.aws.gamelift.model.primitives.ComputeArn(value))
    override val authToken: Optional[ComputeAuthToken] = zio.aws.core.internal
      .optionalFromNullable(impl.authToken())
      .map(value => zio.aws.gamelift.model.primitives.ComputeAuthToken(value))
    override val expirationTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationTimestamp())
        .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse
  ): zio.aws.gamelift.model.GetComputeAuthTokenResponse.ReadOnly = new Wrapper(
    impl
  )
}
