package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class GetGameSessionLogUrlResponse(
    preSignedUrl: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse = {
    import GetGameSessionLogUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse
      .builder()
      .optionallyWith(
        preSignedUrl.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.preSignedUrl)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly =
    zio.aws.gamelift.model.GetGameSessionLogUrlResponse.wrap(buildAwsValue())
}
object GetGameSessionLogUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GetGameSessionLogUrlResponse =
      zio.aws.gamelift.model
        .GetGameSessionLogUrlResponse(preSignedUrl.map(value => value))
    def preSignedUrl: Optional[NonZeroAndMaxString]
    def getPreSignedUrl: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse
  ) extends zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly {
    override val preSignedUrl: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preSignedUrl())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse
  ): zio.aws.gamelift.model.GetGameSessionLogUrlResponse.ReadOnly = new Wrapper(
    impl
  )
}
