package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class InstanceCredentials(
    userName: Optional[NonEmptyString] = Optional.Absent,
    secret: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.InstanceCredentials = {
    import InstanceCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.InstanceCredentials
      .builder()
      .optionallyWith(
        userName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        secret.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.secret)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.InstanceCredentials.ReadOnly =
    zio.aws.gamelift.model.InstanceCredentials.wrap(buildAwsValue())
}
object InstanceCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.InstanceCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.InstanceCredentials =
      zio.aws.gamelift.model.InstanceCredentials(
        userName.map(value => value),
        secret.map(value => value)
      )
    def userName: Optional[NonEmptyString]
    def secret: Optional[NonEmptyString]
    def getUserName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userName", userName)
    def getSecret: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("secret", secret)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.InstanceCredentials
  ) extends zio.aws.gamelift.model.InstanceCredentials.ReadOnly {
    override val userName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val secret: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.secret())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.InstanceCredentials
  ): zio.aws.gamelift.model.InstanceCredentials.ReadOnly = new Wrapper(impl)
}
