package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{NonEmptyString, PositiveInteger}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBuildsRequest(
    status: Optional[zio.aws.gamelift.model.BuildStatus] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListBuildsRequest = {
    import ListBuildsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListBuildsRequest.ReadOnly =
    zio.aws.gamelift.model.ListBuildsRequest.wrap(buildAwsValue())
}
object ListBuildsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListBuildsRequest =
      zio.aws.gamelift.model.ListBuildsRequest(
        status.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def status: Optional[zio.aws.gamelift.model.BuildStatus]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, zio.aws.gamelift.model.BuildStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
  ) extends zio.aws.gamelift.model.ListBuildsRequest.ReadOnly {
    override val status: Optional[zio.aws.gamelift.model.BuildStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.BuildStatus.wrap(value))
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListBuildsRequest
  ): zio.aws.gamelift.model.ListBuildsRequest.ReadOnly = new Wrapper(impl)
}
