package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  ListLocationsLimit
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListLocationsRequest(
    filters: Optional[Iterable[zio.aws.gamelift.model.LocationFilter]] =
      Optional.Absent,
    limit: Optional[ListLocationsLimit] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListLocationsRequest = {
    import ListLocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListLocationsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        limit.map(value => ListLocationsLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListLocationsRequest.ReadOnly =
    zio.aws.gamelift.model.ListLocationsRequest.wrap(buildAwsValue())
}
object ListLocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListLocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListLocationsRequest =
      zio.aws.gamelift.model.ListLocationsRequest(
        filters.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.gamelift.model.LocationFilter]]
    def limit: Optional[ListLocationsLimit]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.gamelift.model.LocationFilter]] =
      AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, ListLocationsLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListLocationsRequest
  ) extends zio.aws.gamelift.model.ListLocationsRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.gamelift.model.LocationFilter]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.LocationFilter.wrap(item)
          }.toList
        )
    override val limit: Optional[ListLocationsLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.ListLocationsLimit(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListLocationsRequest
  ): zio.aws.gamelift.model.ListLocationsRequest.ReadOnly = new Wrapper(impl)
}
