package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{LocationArnModel, LocationStringModel}
import scala.jdk.CollectionConverters._
final case class LocationModel(
    locationName: Optional[LocationStringModel] = Optional.Absent,
    locationArn: Optional[LocationArnModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.LocationModel = {
    import LocationModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.LocationModel
      .builder()
      .optionallyWith(
        locationName.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.locationName)
      .optionallyWith(
        locationArn.map(value =>
          LocationArnModel.unwrap(value): java.lang.String
        )
      )(_.locationArn)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.LocationModel.ReadOnly =
    zio.aws.gamelift.model.LocationModel.wrap(buildAwsValue())
}
object LocationModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.LocationModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.LocationModel =
      zio.aws.gamelift.model.LocationModel(
        locationName.map(value => value),
        locationArn.map(value => value)
      )
    def locationName: Optional[LocationStringModel]
    def locationArn: Optional[LocationArnModel]
    def getLocationName: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("locationName", locationName)
    def getLocationArn: ZIO[Any, AwsError, LocationArnModel] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.LocationModel
  ) extends zio.aws.gamelift.model.LocationModel.ReadOnly {
    override val locationName: Optional[LocationStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationName())
        .map(value =>
          zio.aws.gamelift.model.primitives.LocationStringModel(value)
        )
    override val locationArn: Optional[LocationArnModel] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.gamelift.model.primitives.LocationArnModel(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.LocationModel
  ): zio.aws.gamelift.model.LocationModel.ReadOnly = new Wrapper(impl)
}
