package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  ArnStringModel,
  SnsArnStringModel,
  CustomEventData,
  WholeNumber,
  Timestamp,
  MatchmakingAcceptanceTimeoutInteger,
  BooleanModel,
  MatchmakingRuleSetArn,
  GameSessionData,
  NonZeroAndMaxString,
  MatchmakingRequestTimeoutInteger,
  MatchmakingConfigurationArn,
  MatchmakingIdStringModel
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class MatchmakingConfiguration(
    name: Optional[MatchmakingIdStringModel] = Optional.Absent,
    configurationArn: Optional[MatchmakingConfigurationArn] = Optional.Absent,
    description: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionQueueArns: Optional[Iterable[ArnStringModel]] = Optional.Absent,
    requestTimeoutSeconds: Optional[MatchmakingRequestTimeoutInteger] =
      Optional.Absent,
    acceptanceTimeoutSeconds: Optional[MatchmakingAcceptanceTimeoutInteger] =
      Optional.Absent,
    acceptanceRequired: Optional[BooleanModel] = Optional.Absent,
    ruleSetName: Optional[MatchmakingIdStringModel] = Optional.Absent,
    ruleSetArn: Optional[MatchmakingRuleSetArn] = Optional.Absent,
    notificationTarget: Optional[SnsArnStringModel] = Optional.Absent,
    additionalPlayerCount: Optional[WholeNumber] = Optional.Absent,
    customEventData: Optional[CustomEventData] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    gameProperties: Optional[Iterable[zio.aws.gamelift.model.GameProperty]] =
      Optional.Absent,
    gameSessionData: Optional[GameSessionData] = Optional.Absent,
    backfillMode: Optional[zio.aws.gamelift.model.BackfillMode] =
      Optional.Absent,
    flexMatchMode: Optional[zio.aws.gamelift.model.FlexMatchMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration = {
    import MatchmakingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
      .builder()
      .optionallyWith(
        name.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        configurationArn.map(value =>
          MatchmakingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.configurationArn)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        gameSessionQueueArns.map(value =>
          value.map { item =>
            ArnStringModel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.gameSessionQueueArns)
      .optionallyWith(
        requestTimeoutSeconds.map(value =>
          MatchmakingRequestTimeoutInteger.unwrap(value): Integer
        )
      )(_.requestTimeoutSeconds)
      .optionallyWith(
        acceptanceTimeoutSeconds.map(value =>
          MatchmakingAcceptanceTimeoutInteger.unwrap(value): Integer
        )
      )(_.acceptanceTimeoutSeconds)
      .optionallyWith(
        acceptanceRequired.map(value =>
          BooleanModel.unwrap(value): java.lang.Boolean
        )
      )(_.acceptanceRequired)
      .optionallyWith(
        ruleSetName.map(value =>
          MatchmakingIdStringModel.unwrap(value): java.lang.String
        )
      )(_.ruleSetName)
      .optionallyWith(
        ruleSetArn.map(value =>
          MatchmakingRuleSetArn.unwrap(value): java.lang.String
        )
      )(_.ruleSetArn)
      .optionallyWith(
        notificationTarget.map(value =>
          SnsArnStringModel.unwrap(value): java.lang.String
        )
      )(_.notificationTarget)
      .optionallyWith(
        additionalPlayerCount.map(value => WholeNumber.unwrap(value): Integer)
      )(_.additionalPlayerCount)
      .optionallyWith(
        customEventData.map(value =>
          CustomEventData.unwrap(value): java.lang.String
        )
      )(_.customEventData)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        gameSessionData.map(value =>
          GameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(backfillMode.map(value => value.unwrap))(_.backfillMode)
      .optionallyWith(flexMatchMode.map(value => value.unwrap))(_.flexMatchMode)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly =
    zio.aws.gamelift.model.MatchmakingConfiguration.wrap(buildAwsValue())
}
object MatchmakingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.MatchmakingConfiguration =
      zio.aws.gamelift.model.MatchmakingConfiguration(
        name.map(value => value),
        configurationArn.map(value => value),
        description.map(value => value),
        gameSessionQueueArns.map(value => value),
        requestTimeoutSeconds.map(value => value),
        acceptanceTimeoutSeconds.map(value => value),
        acceptanceRequired.map(value => value),
        ruleSetName.map(value => value),
        ruleSetArn.map(value => value),
        notificationTarget.map(value => value),
        additionalPlayerCount.map(value => value),
        customEventData.map(value => value),
        creationTime.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gameSessionData.map(value => value),
        backfillMode.map(value => value),
        flexMatchMode.map(value => value)
      )
    def name: Optional[MatchmakingIdStringModel]
    def configurationArn: Optional[MatchmakingConfigurationArn]
    def description: Optional[NonZeroAndMaxString]
    def gameSessionQueueArns: Optional[List[ArnStringModel]]
    def requestTimeoutSeconds: Optional[MatchmakingRequestTimeoutInteger]
    def acceptanceTimeoutSeconds: Optional[MatchmakingAcceptanceTimeoutInteger]
    def acceptanceRequired: Optional[BooleanModel]
    def ruleSetName: Optional[MatchmakingIdStringModel]
    def ruleSetArn: Optional[MatchmakingRuleSetArn]
    def notificationTarget: Optional[SnsArnStringModel]
    def additionalPlayerCount: Optional[WholeNumber]
    def customEventData: Optional[CustomEventData]
    def creationTime: Optional[Timestamp]
    def gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def gameSessionData: Optional[GameSessionData]
    def backfillMode: Optional[zio.aws.gamelift.model.BackfillMode]
    def flexMatchMode: Optional[zio.aws.gamelift.model.FlexMatchMode]
    def getName: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("name", name)
    def getConfigurationArn: ZIO[Any, AwsError, MatchmakingConfigurationArn] =
      AwsError.unwrapOptionField("configurationArn", configurationArn)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getGameSessionQueueArns: ZIO[Any, AwsError, List[ArnStringModel]] =
      AwsError.unwrapOptionField("gameSessionQueueArns", gameSessionQueueArns)
    def getRequestTimeoutSeconds
        : ZIO[Any, AwsError, MatchmakingRequestTimeoutInteger] =
      AwsError.unwrapOptionField("requestTimeoutSeconds", requestTimeoutSeconds)
    def getAcceptanceTimeoutSeconds
        : ZIO[Any, AwsError, MatchmakingAcceptanceTimeoutInteger] = AwsError
      .unwrapOptionField("acceptanceTimeoutSeconds", acceptanceTimeoutSeconds)
    def getAcceptanceRequired: ZIO[Any, AwsError, BooleanModel] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getRuleSetName: ZIO[Any, AwsError, MatchmakingIdStringModel] =
      AwsError.unwrapOptionField("ruleSetName", ruleSetName)
    def getRuleSetArn: ZIO[Any, AwsError, MatchmakingRuleSetArn] =
      AwsError.unwrapOptionField("ruleSetArn", ruleSetArn)
    def getNotificationTarget: ZIO[Any, AwsError, SnsArnStringModel] =
      AwsError.unwrapOptionField("notificationTarget", notificationTarget)
    def getAdditionalPlayerCount: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("additionalPlayerCount", additionalPlayerCount)
    def getCustomEventData: ZIO[Any, AwsError, CustomEventData] =
      AwsError.unwrapOptionField("customEventData", customEventData)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getGameSessionData: ZIO[Any, AwsError, GameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getBackfillMode
        : ZIO[Any, AwsError, zio.aws.gamelift.model.BackfillMode] =
      AwsError.unwrapOptionField("backfillMode", backfillMode)
    def getFlexMatchMode
        : ZIO[Any, AwsError, zio.aws.gamelift.model.FlexMatchMode] =
      AwsError.unwrapOptionField("flexMatchMode", flexMatchMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
  ) extends zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly {
    override val name: Optional[MatchmakingIdStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
        )
    override val configurationArn: Optional[MatchmakingConfigurationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingConfigurationArn(value)
        )
    override val description: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameSessionQueueArns: Optional[List[ArnStringModel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionQueueArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.ArnStringModel(item)
          }.toList
        )
    override val requestTimeoutSeconds
        : Optional[MatchmakingRequestTimeoutInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.requestTimeoutSeconds())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .MatchmakingRequestTimeoutInteger(value)
      )
    override val acceptanceTimeoutSeconds
        : Optional[MatchmakingAcceptanceTimeoutInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptanceTimeoutSeconds())
      .map(value =>
        zio.aws.gamelift.model.primitives
          .MatchmakingAcceptanceTimeoutInteger(value)
      )
    override val acceptanceRequired: Optional[BooleanModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptanceRequired())
        .map(value => zio.aws.gamelift.model.primitives.BooleanModel(value))
    override val ruleSetName: Optional[MatchmakingIdStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleSetName())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingIdStringModel(value)
        )
    override val ruleSetArn: Optional[MatchmakingRuleSetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleSetArn())
        .map(value =>
          zio.aws.gamelift.model.primitives.MatchmakingRuleSetArn(value)
        )
    override val notificationTarget: Optional[SnsArnStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationTarget())
        .map(value =>
          zio.aws.gamelift.model.primitives.SnsArnStringModel(value)
        )
    override val additionalPlayerCount: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalPlayerCount())
        .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val customEventData: Optional[CustomEventData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEventData())
        .map(value => zio.aws.gamelift.model.primitives.CustomEventData(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameProperty.wrap(item)
          }.toList
        )
    override val gameSessionData: Optional[GameSessionData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionData())
        .map(value => zio.aws.gamelift.model.primitives.GameSessionData(value))
    override val backfillMode: Optional[zio.aws.gamelift.model.BackfillMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backfillMode())
        .map(value => zio.aws.gamelift.model.BackfillMode.wrap(value))
    override val flexMatchMode: Optional[zio.aws.gamelift.model.FlexMatchMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flexMatchMode())
        .map(value => zio.aws.gamelift.model.FlexMatchMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.MatchmakingConfiguration
  ): zio.aws.gamelift.model.MatchmakingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
