package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait OperatingSystem {
  def unwrap: software.amazon.awssdk.services.gamelift.model.OperatingSystem
}
object OperatingSystem {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.OperatingSystem
  ): zio.aws.gamelift.model.OperatingSystem = value match {
    case software.amazon.awssdk.services.gamelift.model.OperatingSystem.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.OperatingSystem.WINDOWS_2012 =>
      val r = WINDOWS_2012
      r
    case software.amazon.awssdk.services.gamelift.model.OperatingSystem.AMAZON_LINUX =>
      val r = AMAZON_LINUX
      r
    case software.amazon.awssdk.services.gamelift.model.OperatingSystem.AMAZON_LINUX_2 =>
      val r = AMAZON_LINUX_2
      r
    case software.amazon.awssdk.services.gamelift.model.OperatingSystem.WINDOWS_2016 =>
      val r = WINDOWS_2016
      r
    case software.amazon.awssdk.services.gamelift.model.OperatingSystem.AMAZON_LINUX_2023 =>
      val r = AMAZON_LINUX_2023
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.OperatingSystem =
      software.amazon.awssdk.services.gamelift.model.OperatingSystem.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS_2012 extends zio.aws.gamelift.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.OperatingSystem =
      software.amazon.awssdk.services.gamelift.model.OperatingSystem.WINDOWS_2012
  }
  case object AMAZON_LINUX extends zio.aws.gamelift.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.OperatingSystem =
      software.amazon.awssdk.services.gamelift.model.OperatingSystem.AMAZON_LINUX
  }
  case object AMAZON_LINUX_2 extends zio.aws.gamelift.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.OperatingSystem =
      software.amazon.awssdk.services.gamelift.model.OperatingSystem.AMAZON_LINUX_2
  }
  case object WINDOWS_2016 extends zio.aws.gamelift.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.OperatingSystem =
      software.amazon.awssdk.services.gamelift.model.OperatingSystem.WINDOWS_2016
  }
  case object AMAZON_LINUX_2023 extends zio.aws.gamelift.model.OperatingSystem {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.OperatingSystem =
      software.amazon.awssdk.services.gamelift.model.OperatingSystem.AMAZON_LINUX_2023
  }
}
