package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait PolicyType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.PolicyType
}
object PolicyType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.PolicyType
  ): zio.aws.gamelift.model.PolicyType = value match {
    case software.amazon.awssdk.services.gamelift.model.PolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.PolicyType.RULE_BASED =>
      val r = RuleBased
      r
    case software.amazon.awssdk.services.gamelift.model.PolicyType.TARGET_BASED =>
      val r = TargetBased
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PolicyType =
      software.amazon.awssdk.services.gamelift.model.PolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object RuleBased extends zio.aws.gamelift.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PolicyType =
      software.amazon.awssdk.services.gamelift.model.PolicyType.RULE_BASED
  }
  case object TargetBased extends zio.aws.gamelift.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PolicyType =
      software.amazon.awssdk.services.gamelift.model.PolicyType.TARGET_BASED
  }
}
