package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  FleetId,
  FleetArn,
  PositiveInteger,
  Integer,
  LocationStringModel,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class ScalingPolicy(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    name: Optional[NonZeroAndMaxString] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.ScalingStatusType] =
      Optional.Absent,
    scalingAdjustment: Optional[Integer] = Optional.Absent,
    scalingAdjustmentType: Optional[
      zio.aws.gamelift.model.ScalingAdjustmentType
    ] = Optional.Absent,
    comparisonOperator: Optional[
      zio.aws.gamelift.model.ComparisonOperatorType
    ] = Optional.Absent,
    threshold: Optional[Double] = Optional.Absent,
    evaluationPeriods: Optional[PositiveInteger] = Optional.Absent,
    metricName: Optional[zio.aws.gamelift.model.MetricName] = Optional.Absent,
    policyType: Optional[zio.aws.gamelift.model.PolicyType] = Optional.Absent,
    targetConfiguration: Optional[zio.aws.gamelift.model.TargetConfiguration] =
      Optional.Absent,
    updateStatus: Optional[zio.aws.gamelift.model.LocationUpdateStatus] =
      Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ScalingPolicy = {
    import ScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ScalingPolicy
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(scalingAdjustment.map(value => value: java.lang.Integer))(
        _.scalingAdjustment
      )
      .optionallyWith(scalingAdjustmentType.map(value => value.unwrap))(
        _.scalingAdjustmentType
      )
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .optionallyWith(threshold.map(value => value: java.lang.Double))(
        _.threshold
      )
      .optionallyWith(
        evaluationPeriods.map(value =>
          PositiveInteger.unwrap(value): java.lang.Integer
        )
      )(_.evaluationPeriods)
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(policyType.map(value => value.unwrap))(_.policyType)
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ScalingPolicy.ReadOnly =
    zio.aws.gamelift.model.ScalingPolicy.wrap(buildAwsValue())
}
object ScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ScalingPolicy =
      zio.aws.gamelift.model.ScalingPolicy(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        scalingAdjustment.map(value => value),
        scalingAdjustmentType.map(value => value),
        comparisonOperator.map(value => value),
        threshold.map(value => value),
        evaluationPeriods.map(value => value),
        metricName.map(value => value),
        policyType.map(value => value),
        targetConfiguration.map(value => value.asEditable),
        updateStatus.map(value => value),
        location.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def name: Optional[NonZeroAndMaxString]
    def status: Optional[zio.aws.gamelift.model.ScalingStatusType]
    def scalingAdjustment: Optional[Integer]
    def scalingAdjustmentType
        : Optional[zio.aws.gamelift.model.ScalingAdjustmentType]
    def comparisonOperator
        : Optional[zio.aws.gamelift.model.ComparisonOperatorType]
    def threshold: Optional[Double]
    def evaluationPeriods: Optional[PositiveInteger]
    def metricName: Optional[zio.aws.gamelift.model.MetricName]
    def policyType: Optional[zio.aws.gamelift.model.PolicyType]
    def targetConfiguration
        : Optional[zio.aws.gamelift.model.TargetConfiguration.ReadOnly]
    def updateStatus: Optional[zio.aws.gamelift.model.LocationUpdateStatus]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ScalingStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getScalingAdjustment: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scalingAdjustment", scalingAdjustment)
    def getScalingAdjustmentType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ScalingAdjustmentType] =
      AwsError.unwrapOptionField("scalingAdjustmentType", scalingAdjustmentType)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.gamelift.model.ComparisonOperatorType] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getThreshold: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("threshold", threshold)
    def getEvaluationPeriods: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("evaluationPeriods", evaluationPeriods)
    def getMetricName: ZIO[Any, AwsError, zio.aws.gamelift.model.MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getPolicyType: ZIO[Any, AwsError, zio.aws.gamelift.model.PolicyType] =
      AwsError.unwrapOptionField("policyType", policyType)
    def getTargetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.TargetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.LocationUpdateStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ScalingPolicy
  ) extends zio.aws.gamelift.model.ScalingPolicy.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val status: Optional[zio.aws.gamelift.model.ScalingStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.ScalingStatusType.wrap(value))
    override val scalingAdjustment: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.scalingAdjustment())
      .map(value => value: Integer)
    override val scalingAdjustmentType
        : Optional[zio.aws.gamelift.model.ScalingAdjustmentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingAdjustmentType())
        .map(value => zio.aws.gamelift.model.ScalingAdjustmentType.wrap(value))
    override val comparisonOperator
        : Optional[zio.aws.gamelift.model.ComparisonOperatorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparisonOperator())
        .map(value => zio.aws.gamelift.model.ComparisonOperatorType.wrap(value))
    override val threshold: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => value: Double)
    override val evaluationPeriods: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationPeriods())
        .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val metricName: Optional[zio.aws.gamelift.model.MetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value => zio.aws.gamelift.model.MetricName.wrap(value))
    override val policyType: Optional[zio.aws.gamelift.model.PolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyType())
        .map(value => zio.aws.gamelift.model.PolicyType.wrap(value))
    override val targetConfiguration
        : Optional[zio.aws.gamelift.model.TargetConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetConfiguration())
        .map(value => zio.aws.gamelift.model.TargetConfiguration.wrap(value))
    override val updateStatus
        : Optional[zio.aws.gamelift.model.LocationUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateStatus())
        .map(value => zio.aws.gamelift.model.LocationUpdateStatus.wrap(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ScalingPolicy
  ): zio.aws.gamelift.model.ScalingPolicy.ReadOnly = new Wrapper(impl)
}
