package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait ScalingStatusType {
  def unwrap: software.amazon.awssdk.services.gamelift.model.ScalingStatusType
}
object ScalingStatusType {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.ScalingStatusType
  ): zio.aws.gamelift.model.ScalingStatusType = value match {
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.UPDATE_REQUESTED =>
      val r = UPDATE_REQUESTED
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.DELETE_REQUESTED =>
      val r = DELETE_REQUESTED
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.gamelift.model.ScalingStatusType.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.ACTIVE
  }
  case object UPDATE_REQUESTED
      extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.UPDATE_REQUESTED
  }
  case object UPDATING extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.UPDATING
  }
  case object DELETE_REQUESTED
      extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.DELETE_REQUESTED
  }
  case object DELETING extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.DELETING
  }
  case object DELETED extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.DELETED
  }
  case object ERROR extends zio.aws.gamelift.model.ScalingStatusType {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.ScalingStatusType =
      software.amazon.awssdk.services.gamelift.model.ScalingStatusType.ERROR
  }
}
