package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopGameSessionPlacementResponse(
    gameSessionPlacement: Optional[
      zio.aws.gamelift.model.GameSessionPlacement
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse = {
    import StopGameSessionPlacementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse
      .builder()
      .optionallyWith(gameSessionPlacement.map(value => value.buildAwsValue()))(
        _.gameSessionPlacement
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly =
    zio.aws.gamelift.model.StopGameSessionPlacementResponse
      .wrap(buildAwsValue())
}
object StopGameSessionPlacementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StopGameSessionPlacementResponse =
      zio.aws.gamelift.model.StopGameSessionPlacementResponse(
        gameSessionPlacement.map(value => value.asEditable)
      )
    def gameSessionPlacement
        : Optional[zio.aws.gamelift.model.GameSessionPlacement.ReadOnly]
    def getGameSessionPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameSessionPlacement.ReadOnly
    ] = AwsError.unwrapOptionField("gameSessionPlacement", gameSessionPlacement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse
  ) extends zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly {
    override val gameSessionPlacement
        : Optional[zio.aws.gamelift.model.GameSessionPlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionPlacement())
        .map(value => zio.aws.gamelift.model.GameSessionPlacement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse
  ): zio.aws.gamelift.model.StopGameSessionPlacementResponse.ReadOnly =
    new Wrapper(impl)
}
