package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{NonZeroAndMaxString, BuildIdOrArn}
import scala.jdk.CollectionConverters._
final case class UpdateBuildRequest(
    buildId: BuildIdOrArn,
    name: Optional[NonZeroAndMaxString] = Optional.Absent,
    version: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest = {
    import UpdateBuildRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest
      .builder()
      .buildId(BuildIdOrArn.unwrap(buildId): java.lang.String)
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateBuildRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateBuildRequest.wrap(buildAwsValue())
}
object UpdateBuildRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateBuildRequest =
      zio.aws.gamelift.model.UpdateBuildRequest(
        buildId,
        name.map(value => value),
        version.map(value => value)
      )
    def buildId: BuildIdOrArn
    def name: Optional[NonZeroAndMaxString]
    def version: Optional[NonZeroAndMaxString]
    def getBuildId: ZIO[Any, Nothing, BuildIdOrArn] = ZIO.succeed(buildId)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest
  ) extends zio.aws.gamelift.model.UpdateBuildRequest.ReadOnly {
    override val buildId: BuildIdOrArn =
      zio.aws.gamelift.model.primitives.BuildIdOrArn(impl.buildId())
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val version: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest
  ): zio.aws.gamelift.model.UpdateBuildRequest.ReadOnly = new Wrapper(impl)
}
