package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{FleetArn, FleetId}
import scala.jdk.CollectionConverters._
final case class UpdateFleetAttributesResponse(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse = {
    import UpdateFleetAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetAttributesResponse.wrap(buildAwsValue())
}
object UpdateFleetAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetAttributesResponse =
      zio.aws.gamelift.model.UpdateFleetAttributesResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
  ) extends zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse
  ): zio.aws.gamelift.model.UpdateFleetAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
