package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.FleetIdOrArn
import scala.jdk.CollectionConverters._
final case class UpdateFleetPortSettingsRequest(
    fleetId: FleetIdOrArn,
    inboundPermissionAuthorizations: Optional[
      Iterable[zio.aws.gamelift.model.IpPermission]
    ] = Optional.Absent,
    inboundPermissionRevocations: Optional[
      Iterable[zio.aws.gamelift.model.IpPermission]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest = {
    import UpdateFleetPortSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        inboundPermissionAuthorizations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inboundPermissionAuthorizations)
      .optionallyWith(
        inboundPermissionRevocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inboundPermissionRevocations)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateFleetPortSettingsRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetPortSettingsRequest.wrap(buildAwsValue())
}
object UpdateFleetPortSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetPortSettingsRequest =
      zio.aws.gamelift.model.UpdateFleetPortSettingsRequest(
        fleetId,
        inboundPermissionAuthorizations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inboundPermissionRevocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fleetId: FleetIdOrArn
    def inboundPermissionAuthorizations
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]]
    def inboundPermissionRevocations
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getInboundPermissionAuthorizations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.IpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inboundPermissionAuthorizations",
      inboundPermissionAuthorizations
    )
    def getInboundPermissionRevocations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.IpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inboundPermissionRevocations",
      inboundPermissionRevocations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest
  ) extends zio.aws.gamelift.model.UpdateFleetPortSettingsRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val inboundPermissionAuthorizations
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundPermissionAuthorizations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.IpPermission.wrap(item)
          }.toList
        )
    override val inboundPermissionRevocations
        : Optional[List[zio.aws.gamelift.model.IpPermission.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundPermissionRevocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.IpPermission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest
  ): zio.aws.gamelift.model.UpdateFleetPortSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
