package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGameSessionQueueResponse(
    gameSessionQueue: Optional[zio.aws.gamelift.model.GameSessionQueue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse = {
    import UpdateGameSessionQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse
      .builder()
      .optionallyWith(gameSessionQueue.map(value => value.buildAwsValue()))(
        _.gameSessionQueue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateGameSessionQueueResponse.wrap(buildAwsValue())
}
object UpdateGameSessionQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameSessionQueueResponse =
      zio.aws.gamelift.model.UpdateGameSessionQueueResponse(
        gameSessionQueue.map(value => value.asEditable)
      )
    def gameSessionQueue
        : Optional[zio.aws.gamelift.model.GameSessionQueue.ReadOnly]
    def getGameSessionQueue
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSessionQueue.ReadOnly] =
      AwsError.unwrapOptionField("gameSessionQueue", gameSessionQueue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse
  ) extends zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly {
    override val gameSessionQueue
        : Optional[zio.aws.gamelift.model.GameSessionQueue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionQueue())
        .map(value => zio.aws.gamelift.model.GameSessionQueue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse
  ): zio.aws.gamelift.model.UpdateGameSessionQueueResponse.ReadOnly =
    new Wrapper(impl)
}
