package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  FleetArn,
  FleetId
}
import scala.jdk.CollectionConverters._
final case class VpcPeeringConnection(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    ipV4CidrBlock: Optional[NonZeroAndMaxString] = Optional.Absent,
    vpcPeeringConnectionId: Optional[NonZeroAndMaxString] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.VpcPeeringConnectionStatus] =
      Optional.Absent,
    peerVpcId: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameLiftVpcId: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.VpcPeeringConnection = {
    import VpcPeeringConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.VpcPeeringConnection
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        ipV4CidrBlock.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.ipV4CidrBlock)
      .optionallyWith(
        vpcPeeringConnectionId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.vpcPeeringConnectionId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        peerVpcId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.peerVpcId)
      .optionallyWith(
        gameLiftVpcId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameLiftVpcId)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.VpcPeeringConnection.ReadOnly =
    zio.aws.gamelift.model.VpcPeeringConnection.wrap(buildAwsValue())
}
object VpcPeeringConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.VpcPeeringConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.VpcPeeringConnection =
      zio.aws.gamelift.model.VpcPeeringConnection(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        ipV4CidrBlock.map(value => value),
        vpcPeeringConnectionId.map(value => value),
        status.map(value => value.asEditable),
        peerVpcId.map(value => value),
        gameLiftVpcId.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def ipV4CidrBlock: Optional[NonZeroAndMaxString]
    def vpcPeeringConnectionId: Optional[NonZeroAndMaxString]
    def status
        : Optional[zio.aws.gamelift.model.VpcPeeringConnectionStatus.ReadOnly]
    def peerVpcId: Optional[NonZeroAndMaxString]
    def gameLiftVpcId: Optional[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getIpV4CidrBlock: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("ipV4CidrBlock", ipV4CidrBlock)
    def getVpcPeeringConnectionId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField(
        "vpcPeeringConnectionId",
        vpcPeeringConnectionId
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.VpcPeeringConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getPeerVpcId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("peerVpcId", peerVpcId)
    def getGameLiftVpcId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameLiftVpcId", gameLiftVpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.VpcPeeringConnection
  ) extends zio.aws.gamelift.model.VpcPeeringConnection.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val ipV4CidrBlock: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipV4CidrBlock())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val vpcPeeringConnectionId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcPeeringConnectionId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val status
        : Optional[zio.aws.gamelift.model.VpcPeeringConnectionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.gamelift.model.VpcPeeringConnectionStatus.wrap(value)
        )
    override val peerVpcId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peerVpcId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameLiftVpcId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameLiftVpcId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.VpcPeeringConnection
  ): zio.aws.gamelift.model.VpcPeeringConnection.ReadOnly = new Wrapper(impl)
}
