package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class VpcPeeringConnectionStatus(
    code: Optional[NonZeroAndMaxString] = Optional.Absent,
    message: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.VpcPeeringConnectionStatus = {
    import VpcPeeringConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.VpcPeeringConnectionStatus
      .builder()
      .optionallyWith(
        code.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        message.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.VpcPeeringConnectionStatus.ReadOnly =
    zio.aws.gamelift.model.VpcPeeringConnectionStatus.wrap(buildAwsValue())
}
object VpcPeeringConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.VpcPeeringConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.VpcPeeringConnectionStatus =
      zio.aws.gamelift.model.VpcPeeringConnectionStatus(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[NonZeroAndMaxString]
    def message: Optional[NonZeroAndMaxString]
    def getCode: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.VpcPeeringConnectionStatus
  ) extends zio.aws.gamelift.model.VpcPeeringConnectionStatus.ReadOnly {
    override val code: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val message: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.VpcPeeringConnectionStatus
  ): zio.aws.gamelift.model.VpcPeeringConnectionStatus.ReadOnly = new Wrapper(
    impl
  )
}
