package zio.aws.glacier
import zio.aws.glacier.model.UploadArchiveResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.glacier.{
  GlacierAsyncClientBuilder,
  GlacierAsyncClient
}
import zio.aws.glacier.model.{
  InitiateMultipartUploadRequest,
  SetVaultNotificationsRequest,
  CreateVaultRequest,
  RemoveTagsFromVaultRequest,
  DescribeVaultRequest,
  PurchaseProvisionedCapacityRequest,
  ListJobsRequest,
  GetVaultNotificationsRequest,
  CompleteVaultLockRequest,
  DescribeJobRequest,
  InitiateVaultLockRequest,
  GetJobOutputRequest,
  AbortMultipartUploadRequest,
  DeleteVaultNotificationsRequest,
  SetDataRetrievalPolicyRequest,
  InitiateJobRequest,
  ListMultipartUploadsRequest,
  ListProvisionedCapacityRequest,
  DeleteVaultRequest,
  ListTagsForVaultRequest,
  DeleteArchiveRequest,
  GetVaultLockRequest,
  ListVaultsRequest,
  CompleteMultipartUploadRequest,
  UploadArchiveRequest,
  DeleteVaultAccessPolicyRequest,
  ListPartsRequest,
  GetVaultAccessPolicyRequest,
  SetVaultAccessPolicyRequest,
  AbortVaultLockRequest,
  AddTagsToVaultRequest,
  GetDataRetrievalPolicyRequest,
  UploadMultipartPartRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.glacier.paginators.{
  ListJobsPublisher,
  ListPartsPublisher,
  ListMultipartUploadsPublisher,
  ListVaultsPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.glacier.model.{
  AddTagsToVaultResponse,
  UploadArchiveResponse,
  GetDataRetrievalPolicyResponse,
  GetVaultAccessPolicyResponse,
  GlacierJobDescription,
  DeleteVaultResponse,
  DeleteArchiveResponse,
  GetJobOutputResponse,
  DeleteVaultAccessPolicyResponse,
  SetDataRetrievalPolicyResponse,
  DescribeVaultOutput,
  DescribeJobResponse,
  ListPartsResponse,
  ListProvisionedCapacityResponse,
  UploadMultipartPartResponse,
  PurchaseProvisionedCapacityResponse,
  InitiateVaultLockResponse,
  GetVaultNotificationsResponse,
  SetVaultNotificationsResponse,
  ListVaultsResponse,
  DescribeVaultResponse,
  AbortVaultLockResponse,
  InitiateJobResponse,
  ListTagsForVaultResponse,
  CreateVaultResponse,
  RemoveTagsFromVaultResponse,
  PartListElement,
  GetVaultLockResponse,
  ListJobsResponse,
  AbortMultipartUploadResponse,
  CompleteVaultLockResponse,
  CompleteMultipartUploadResponse,
  ListMultipartUploadsResponse,
  DeleteVaultNotificationsResponse,
  UploadListElement,
  SetVaultAccessPolicyResponse,
  InitiateMultipartUploadResponse
}
import scala.jdk.CollectionConverters._
trait Glacier extends AspectSupport[Glacier] {
  val api: GlacierAsyncClient
  def completeVaultLock(request: CompleteVaultLockRequest): IO[AwsError, Unit]
  def describeJob(
      request: DescribeJobRequest
  ): IO[AwsError, zio.aws.glacier.model.DescribeJobResponse.ReadOnly]
  def deleteVaultAccessPolicy(
      request: DeleteVaultAccessPolicyRequest
  ): IO[AwsError, Unit]
  def deleteVaultNotifications(
      request: DeleteVaultNotificationsRequest
  ): IO[AwsError, Unit]
  def uploadMultipartPart(
      request: UploadMultipartPartRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly]
  def listVaults(
      request: ListVaultsRequest
  ): ZStream[Any, AwsError, zio.aws.glacier.model.DescribeVaultOutput.ReadOnly]
  def listVaultsPaginated(
      request: ListVaultsRequest
  ): IO[AwsError, zio.aws.glacier.model.ListVaultsResponse.ReadOnly]
  def listMultipartUploads(
      request: ListMultipartUploadsRequest
  ): ZStream[Any, AwsError, zio.aws.glacier.model.UploadListElement.ReadOnly]
  def listMultipartUploadsPaginated(
      request: ListMultipartUploadsRequest
  ): IO[AwsError, zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly]
  def listProvisionedCapacity(request: ListProvisionedCapacityRequest): IO[
    AwsError,
    zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly
  ]
  def listParts(
      request: ListPartsRequest
  ): ZStream[Any, AwsError, zio.aws.glacier.model.PartListElement.ReadOnly]
  def listPartsPaginated(
      request: ListPartsRequest
  ): IO[AwsError, zio.aws.glacier.model.ListPartsResponse.ReadOnly]
  def removeTagsFromVault(
      request: RemoveTagsFromVaultRequest
  ): IO[AwsError, Unit]
  def deleteArchive(request: DeleteArchiveRequest): IO[AwsError, Unit]
  def purchaseProvisionedCapacity(
      request: PurchaseProvisionedCapacityRequest
  ): IO[
    AwsError,
    zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly
  ]
  def describeVault(
      request: DescribeVaultRequest
  ): IO[AwsError, zio.aws.glacier.model.DescribeVaultResponse.ReadOnly]
  def initiateVaultLock(
      request: InitiateVaultLockRequest
  ): IO[AwsError, zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly]
  def initiateMultipartUpload(request: InitiateMultipartUploadRequest): IO[
    AwsError,
    zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly
  ]
  def getDataRetrievalPolicy(
      request: GetDataRetrievalPolicyRequest
  ): IO[AwsError, zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly]
  def getVaultNotifications(
      request: GetVaultNotificationsRequest
  ): IO[AwsError, zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly]
  def addTagsToVault(request: AddTagsToVaultRequest): IO[AwsError, Unit]
  def getVaultLock(
      request: GetVaultLockRequest
  ): IO[AwsError, zio.aws.glacier.model.GetVaultLockResponse.ReadOnly]
  def deleteVault(request: DeleteVaultRequest): IO[AwsError, Unit]
  def listJobs(request: ListJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.glacier.model.GlacierJobDescription.ReadOnly
  ]
  def listJobsPaginated(
      request: ListJobsRequest
  ): IO[AwsError, zio.aws.glacier.model.ListJobsResponse.ReadOnly]
  def abortVaultLock(request: AbortVaultLockRequest): IO[AwsError, Unit]
  def setVaultAccessPolicy(
      request: SetVaultAccessPolicyRequest
  ): IO[AwsError, Unit]
  def getVaultAccessPolicy(
      request: GetVaultAccessPolicyRequest
  ): IO[AwsError, zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly]
  def listTagsForVault(
      request: ListTagsForVaultRequest
  ): IO[AwsError, zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly]
  def uploadArchive(
      request: UploadArchiveRequest,
      body: ZStream[Any, AwsError, Byte]
  ): IO[AwsError, ReadOnly]
  def initiateJob(
      request: InitiateJobRequest
  ): IO[AwsError, zio.aws.glacier.model.InitiateJobResponse.ReadOnly]
  def setVaultNotifications(
      request: SetVaultNotificationsRequest
  ): IO[AwsError, Unit]
  def abortMultipartUpload(
      request: AbortMultipartUploadRequest
  ): IO[AwsError, Unit]
  def createVault(
      request: CreateVaultRequest
  ): IO[AwsError, zio.aws.glacier.model.CreateVaultResponse.ReadOnly]
  def getJobOutput(
      request: GetJobOutputRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.glacier.model.GetJobOutputResponse.ReadOnly,
    Byte
  ]]
  def completeMultipartUpload(request: CompleteMultipartUploadRequest): IO[
    AwsError,
    zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly
  ]
  def setDataRetrievalPolicy(
      request: SetDataRetrievalPolicyRequest
  ): IO[AwsError, Unit]
}
object Glacier {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Glacier] = customized(
    identity
  )
  def customized(
      customization: GlacierAsyncClientBuilder => GlacierAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Glacier] = managed(
    customization
  ).toLayer
  def managed(
      customization: GlacierAsyncClientBuilder => GlacierAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Glacier] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = GlacierAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[GlacierAsyncClient, GlacierAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[GlacierAsyncClient, GlacierAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new GlacierImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class GlacierImpl[R](
      override val api: GlacierAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Glacier
      with AwsServiceBase[R] {
    override val serviceName: String = "Glacier"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): GlacierImpl[R1] = new GlacierImpl(api, newAspect, r)
    def completeVaultLock(
        request: CompleteVaultLockRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.CompleteVaultLockRequest,
      CompleteVaultLockResponse
    ]("completeVaultLock", api.completeVaultLock)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeJob(
        request: DescribeJobRequest
    ): IO[AwsError, zio.aws.glacier.model.DescribeJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.DescribeJobRequest,
        DescribeJobResponse
      ]("describeJob", api.describeJob)(request.buildAwsValue())
        .map(zio.aws.glacier.model.DescribeJobResponse.wrap)
        .provideEnvironment(r)
    def deleteVaultAccessPolicy(
        request: DeleteVaultAccessPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.DeleteVaultAccessPolicyRequest,
      DeleteVaultAccessPolicyResponse
    ]("deleteVaultAccessPolicy", api.deleteVaultAccessPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteVaultNotifications(
        request: DeleteVaultNotificationsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.DeleteVaultNotificationsRequest,
      DeleteVaultNotificationsResponse
    ]("deleteVaultNotifications", api.deleteVaultNotifications)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def uploadMultipartPart(
        request: UploadMultipartPartRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[
      AwsError,
      zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly
    ] = asyncRequestInputStream[
      software.amazon.awssdk.services.glacier.model.UploadMultipartPartRequest,
      UploadMultipartPartResponse
    ]("uploadMultipartPart", api.uploadMultipartPart)(
      request.buildAwsValue(),
      body
    ).map(zio.aws.glacier.model.UploadMultipartPartResponse.wrap)
      .provideEnvironment(r)
    def listVaults(request: ListVaultsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.glacier.model.DescribeVaultOutput.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.glacier.model.ListVaultsRequest,
      DescribeVaultOutput,
      ListVaultsPublisher
    ]("listVaults", api.listVaultsPaginator, _.vaultList())(
      request.buildAwsValue()
    ).map(item => zio.aws.glacier.model.DescribeVaultOutput.wrap(item))
      .provideEnvironment(r)
    def listVaultsPaginated(
        request: ListVaultsRequest
    ): IO[AwsError, zio.aws.glacier.model.ListVaultsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.ListVaultsRequest,
        ListVaultsResponse
      ]("listVaults", api.listVaults)(request.buildAwsValue())
        .map(zio.aws.glacier.model.ListVaultsResponse.wrap)
        .provideEnvironment(r)
    def listMultipartUploads(request: ListMultipartUploadsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.glacier.model.UploadListElement.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest,
      UploadListElement,
      ListMultipartUploadsPublisher
    ](
      "listMultipartUploads",
      api.listMultipartUploadsPaginator,
      _.uploadsList()
    )(request.buildAwsValue())
      .map(item => zio.aws.glacier.model.UploadListElement.wrap(item))
      .provideEnvironment(r)
    def listMultipartUploadsPaginated(request: ListMultipartUploadsRequest): IO[
      AwsError,
      zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.ListMultipartUploadsRequest,
      ListMultipartUploadsResponse
    ]("listMultipartUploads", api.listMultipartUploads)(request.buildAwsValue())
      .map(zio.aws.glacier.model.ListMultipartUploadsResponse.wrap)
      .provideEnvironment(r)
    def listProvisionedCapacity(request: ListProvisionedCapacityRequest): IO[
      AwsError,
      zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.ListProvisionedCapacityRequest,
      ListProvisionedCapacityResponse
    ]("listProvisionedCapacity", api.listProvisionedCapacity)(
      request.buildAwsValue()
    ).map(zio.aws.glacier.model.ListProvisionedCapacityResponse.wrap)
      .provideEnvironment(r)
    def listParts(
        request: ListPartsRequest
    ): ZStream[Any, AwsError, zio.aws.glacier.model.PartListElement.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.glacier.model.ListPartsRequest,
        PartListElement,
        ListPartsPublisher
      ]("listParts", api.listPartsPaginator, _.parts())(request.buildAwsValue())
        .map(item => zio.aws.glacier.model.PartListElement.wrap(item))
        .provideEnvironment(r)
    def listPartsPaginated(
        request: ListPartsRequest
    ): IO[AwsError, zio.aws.glacier.model.ListPartsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.ListPartsRequest,
        ListPartsResponse
      ]("listParts", api.listParts)(request.buildAwsValue())
        .map(zio.aws.glacier.model.ListPartsResponse.wrap)
        .provideEnvironment(r)
    def removeTagsFromVault(
        request: RemoveTagsFromVaultRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.RemoveTagsFromVaultRequest,
      RemoveTagsFromVaultResponse
    ]("removeTagsFromVault", api.removeTagsFromVault)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteArchive(request: DeleteArchiveRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.DeleteArchiveRequest,
        DeleteArchiveResponse
      ]("deleteArchive", api.deleteArchive)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def purchaseProvisionedCapacity(
        request: PurchaseProvisionedCapacityRequest
    ): IO[
      AwsError,
      zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.PurchaseProvisionedCapacityRequest,
      PurchaseProvisionedCapacityResponse
    ]("purchaseProvisionedCapacity", api.purchaseProvisionedCapacity)(
      request.buildAwsValue()
    ).map(zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.wrap)
      .provideEnvironment(r)
    def describeVault(
        request: DescribeVaultRequest
    ): IO[AwsError, zio.aws.glacier.model.DescribeVaultResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.DescribeVaultRequest,
        DescribeVaultResponse
      ]("describeVault", api.describeVault)(request.buildAwsValue())
        .map(zio.aws.glacier.model.DescribeVaultResponse.wrap)
        .provideEnvironment(r)
    def initiateVaultLock(
        request: InitiateVaultLockRequest
    ): IO[AwsError, zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.InitiateVaultLockRequest,
        InitiateVaultLockResponse
      ]("initiateVaultLock", api.initiateVaultLock)(request.buildAwsValue())
        .map(zio.aws.glacier.model.InitiateVaultLockResponse.wrap)
        .provideEnvironment(r)
    def initiateMultipartUpload(request: InitiateMultipartUploadRequest): IO[
      AwsError,
      zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.InitiateMultipartUploadRequest,
      InitiateMultipartUploadResponse
    ]("initiateMultipartUpload", api.initiateMultipartUpload)(
      request.buildAwsValue()
    ).map(zio.aws.glacier.model.InitiateMultipartUploadResponse.wrap)
      .provideEnvironment(r)
    def getDataRetrievalPolicy(request: GetDataRetrievalPolicyRequest): IO[
      AwsError,
      zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest,
      GetDataRetrievalPolicyResponse
    ]("getDataRetrievalPolicy", api.getDataRetrievalPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.glacier.model.GetDataRetrievalPolicyResponse.wrap)
      .provideEnvironment(r)
    def getVaultNotifications(request: GetVaultNotificationsRequest): IO[
      AwsError,
      zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.GetVaultNotificationsRequest,
      GetVaultNotificationsResponse
    ]("getVaultNotifications", api.getVaultNotifications)(
      request.buildAwsValue()
    ).map(zio.aws.glacier.model.GetVaultNotificationsResponse.wrap)
      .provideEnvironment(r)
    def addTagsToVault(request: AddTagsToVaultRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.AddTagsToVaultRequest,
        AddTagsToVaultResponse
      ]("addTagsToVault", api.addTagsToVault)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getVaultLock(
        request: GetVaultLockRequest
    ): IO[AwsError, zio.aws.glacier.model.GetVaultLockResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.GetVaultLockRequest,
        GetVaultLockResponse
      ]("getVaultLock", api.getVaultLock)(request.buildAwsValue())
        .map(zio.aws.glacier.model.GetVaultLockResponse.wrap)
        .provideEnvironment(r)
    def deleteVault(request: DeleteVaultRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.DeleteVaultRequest,
        DeleteVaultResponse
      ]("deleteVault", api.deleteVault)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listJobs(request: ListJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.glacier.model.GlacierJobDescription.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.glacier.model.ListJobsRequest,
      GlacierJobDescription,
      ListJobsPublisher
    ]("listJobs", api.listJobsPaginator, _.jobList())(request.buildAwsValue())
      .map(item => zio.aws.glacier.model.GlacierJobDescription.wrap(item))
      .provideEnvironment(r)
    def listJobsPaginated(
        request: ListJobsRequest
    ): IO[AwsError, zio.aws.glacier.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.ListJobsRequest,
        ListJobsResponse
      ]("listJobs", api.listJobs)(request.buildAwsValue())
        .map(zio.aws.glacier.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def abortVaultLock(request: AbortVaultLockRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest,
        AbortVaultLockResponse
      ]("abortVaultLock", api.abortVaultLock)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def setVaultAccessPolicy(
        request: SetVaultAccessPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.SetVaultAccessPolicyRequest,
      SetVaultAccessPolicyResponse
    ]("setVaultAccessPolicy", api.setVaultAccessPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getVaultAccessPolicy(request: GetVaultAccessPolicyRequest): IO[
      AwsError,
      zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.GetVaultAccessPolicyRequest,
      GetVaultAccessPolicyResponse
    ]("getVaultAccessPolicy", api.getVaultAccessPolicy)(request.buildAwsValue())
      .map(zio.aws.glacier.model.GetVaultAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def listTagsForVault(
        request: ListTagsForVaultRequest
    ): IO[AwsError, zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.ListTagsForVaultRequest,
        ListTagsForVaultResponse
      ]("listTagsForVault", api.listTagsForVault)(request.buildAwsValue())
        .map(zio.aws.glacier.model.ListTagsForVaultResponse.wrap)
        .provideEnvironment(r)
    def uploadArchive(
        request: UploadArchiveRequest,
        body: ZStream[Any, AwsError, Byte]
    ): IO[AwsError, ReadOnly] = asyncRequestInputStream[
      software.amazon.awssdk.services.glacier.model.UploadArchiveRequest,
      UploadArchiveResponse
    ]("uploadArchive", api.uploadArchive)(request.buildAwsValue(), body)
      .map(zio.aws.glacier.model.UploadArchiveResponse.wrap)
      .provideEnvironment(r)
    def initiateJob(
        request: InitiateJobRequest
    ): IO[AwsError, zio.aws.glacier.model.InitiateJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.InitiateJobRequest,
        InitiateJobResponse
      ]("initiateJob", api.initiateJob)(request.buildAwsValue())
        .map(zio.aws.glacier.model.InitiateJobResponse.wrap)
        .provideEnvironment(r)
    def setVaultNotifications(
        request: SetVaultNotificationsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.SetVaultNotificationsRequest,
      SetVaultNotificationsResponse
    ]("setVaultNotifications", api.setVaultNotifications)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def abortMultipartUpload(
        request: AbortMultipartUploadRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest,
      AbortMultipartUploadResponse
    ]("abortMultipartUpload", api.abortMultipartUpload)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createVault(
        request: CreateVaultRequest
    ): IO[AwsError, zio.aws.glacier.model.CreateVaultResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.glacier.model.CreateVaultRequest,
        CreateVaultResponse
      ]("createVault", api.createVault)(request.buildAwsValue())
        .map(zio.aws.glacier.model.CreateVaultResponse.wrap)
        .provideEnvironment(r)
    def getJobOutput(
        request: GetJobOutputRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.glacier.model.GetJobOutputResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.glacier.model.GetJobOutputRequest,
      GetJobOutputResponse
    ](
      "getJobOutput",
      api.getJobOutput[Task[
        StreamingOutputResult[R, GetJobOutputResponse, Byte]
      ]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.glacier.model.GetJobOutputResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def completeMultipartUpload(request: CompleteMultipartUploadRequest): IO[
      AwsError,
      zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest,
      CompleteMultipartUploadResponse
    ]("completeMultipartUpload", api.completeMultipartUpload)(
      request.buildAwsValue()
    ).map(zio.aws.glacier.model.CompleteMultipartUploadResponse.wrap)
      .provideEnvironment(r)
    def setDataRetrievalPolicy(
        request: SetDataRetrievalPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.glacier.model.SetDataRetrievalPolicyRequest,
      SetDataRetrievalPolicyResponse
    ]("setDataRetrievalPolicy", api.setDataRetrievalPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
  }
  def completeVaultLock(
      request: CompleteVaultLockRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.completeVaultLock(request))
  def describeJob(request: DescribeJobRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.DescribeJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeJob(request))
  def deleteVaultAccessPolicy(
      request: DeleteVaultAccessPolicyRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVaultAccessPolicy(request))
  def deleteVaultNotifications(
      request: DeleteVaultNotificationsRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVaultNotifications(request))
  def uploadMultipartPart(
      request: UploadMultipartPartRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.UploadMultipartPartResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.uploadMultipartPart(request, body))
  def listVaults(request: ListVaultsRequest): ZStream[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.DescribeVaultOutput.ReadOnly
  ] = ZStream.serviceWithStream(_.listVaults(request))
  def listVaultsPaginated(request: ListVaultsRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.ListVaultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVaultsPaginated(request))
  def listMultipartUploads(request: ListMultipartUploadsRequest): ZStream[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.UploadListElement.ReadOnly
  ] = ZStream.serviceWithStream(_.listMultipartUploads(request))
  def listMultipartUploadsPaginated(request: ListMultipartUploadsRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.ListMultipartUploadsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMultipartUploadsPaginated(request))
  def listProvisionedCapacity(request: ListProvisionedCapacityRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.ListProvisionedCapacityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProvisionedCapacity(request))
  def listParts(request: ListPartsRequest): ZStream[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.PartListElement.ReadOnly
  ] = ZStream.serviceWithStream(_.listParts(request))
  def listPartsPaginated(request: ListPartsRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.ListPartsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPartsPaginated(request))
  def removeTagsFromVault(
      request: RemoveTagsFromVaultRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTagsFromVault(request))
  def deleteArchive(
      request: DeleteArchiveRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteArchive(request))
  def purchaseProvisionedCapacity(
      request: PurchaseProvisionedCapacityRequest
  ): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.PurchaseProvisionedCapacityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseProvisionedCapacity(request))
  def describeVault(request: DescribeVaultRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.DescribeVaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVault(request))
  def initiateVaultLock(request: InitiateVaultLockRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.InitiateVaultLockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initiateVaultLock(request))
  def initiateMultipartUpload(request: InitiateMultipartUploadRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.InitiateMultipartUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initiateMultipartUpload(request))
  def getDataRetrievalPolicy(request: GetDataRetrievalPolicyRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.GetDataRetrievalPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataRetrievalPolicy(request))
  def getVaultNotifications(request: GetVaultNotificationsRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.GetVaultNotificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVaultNotifications(request))
  def addTagsToVault(
      request: AddTagsToVaultRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTagsToVault(request))
  def getVaultLock(request: GetVaultLockRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.GetVaultLockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVaultLock(request))
  def deleteVault(
      request: DeleteVaultRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVault(request))
  def listJobs(request: ListJobsRequest): ZStream[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.GlacierJobDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: ListJobsRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def abortVaultLock(
      request: AbortVaultLockRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.abortVaultLock(request))
  def setVaultAccessPolicy(
      request: SetVaultAccessPolicyRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setVaultAccessPolicy(request))
  def getVaultAccessPolicy(request: GetVaultAccessPolicyRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.GetVaultAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVaultAccessPolicy(request))
  def listTagsForVault(request: ListTagsForVaultRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.ListTagsForVaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForVault(request))
  def uploadArchive(
      request: UploadArchiveRequest,
      body: ZStream[Any, AwsError, Byte]
  ): ZIO[zio.aws.glacier.Glacier, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.uploadArchive(request, body))
  def initiateJob(request: InitiateJobRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.InitiateJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.initiateJob(request))
  def setVaultNotifications(
      request: SetVaultNotificationsRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setVaultNotifications(request))
  def abortMultipartUpload(
      request: AbortMultipartUploadRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.abortMultipartUpload(request))
  def createVault(request: CreateVaultRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.CreateVaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVault(request))
  def getJobOutput(
      request: GetJobOutputRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, StreamingOutputResult[
    Any,
    zio.aws.glacier.model.GetJobOutputResponse.ReadOnly,
    Byte
  ]] = ZIO.serviceWithZIO(_.getJobOutput(request))
  def completeMultipartUpload(request: CompleteMultipartUploadRequest): ZIO[
    zio.aws.glacier.Glacier,
    AwsError,
    zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.completeMultipartUpload(request))
  def setDataRetrievalPolicy(
      request: SetDataRetrievalPolicyRequest
  ): ZIO[zio.aws.glacier.Glacier, AwsError, Unit] =
    ZIO.serviceWithZIO(_.setDataRetrievalPolicy(request))
}
