package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AbortMultipartUploadRequest(
    accountId: String,
    vaultName: String,
    uploadId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest = {
    import AbortMultipartUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .uploadId(uploadId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.AbortMultipartUploadRequest.ReadOnly =
    zio.aws.glacier.model.AbortMultipartUploadRequest.wrap(buildAwsValue())
}
object AbortMultipartUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.AbortMultipartUploadRequest =
      zio.aws.glacier.model
        .AbortMultipartUploadRequest(accountId, vaultName, uploadId)
    def accountId: String
    def vaultName: String
    def uploadId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getUploadId: ZIO[Any, Nothing, String] = ZIO.succeed(uploadId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest
  ) extends zio.aws.glacier.model.AbortMultipartUploadRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val uploadId: String = impl.uploadId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.AbortMultipartUploadRequest
  ): zio.aws.glacier.model.AbortMultipartUploadRequest.ReadOnly = new Wrapper(
    impl
  )
}
