package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AbortVaultLockRequest(accountId: String, vaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest = {
    import AbortVaultLockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.AbortVaultLockRequest.ReadOnly =
    zio.aws.glacier.model.AbortVaultLockRequest.wrap(buildAwsValue())
}
object AbortVaultLockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.AbortVaultLockRequest =
      zio.aws.glacier.model.AbortVaultLockRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest
  ) extends zio.aws.glacier.model.AbortVaultLockRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.AbortVaultLockRequest
  ): zio.aws.glacier.model.AbortVaultLockRequest.ReadOnly = new Wrapper(impl)
}
