package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait ActionCode {
  def unwrap: software.amazon.awssdk.services.glacier.model.ActionCode
}
object ActionCode {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.ActionCode
  ): zio.aws.glacier.model.ActionCode = value match {
    case software.amazon.awssdk.services.glacier.model.ActionCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.ActionCode.ARCHIVE_RETRIEVAL =>
      val r = ArchiveRetrieval
      r
    case software.amazon.awssdk.services.glacier.model.ActionCode.INVENTORY_RETRIEVAL =>
      val r = InventoryRetrieval
      r
    case software.amazon.awssdk.services.glacier.model.ActionCode.SELECT =>
      val r = Select
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.ActionCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.ActionCode =
      software.amazon.awssdk.services.glacier.model.ActionCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ArchiveRetrieval extends zio.aws.glacier.model.ActionCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.ActionCode =
      software.amazon.awssdk.services.glacier.model.ActionCode.ARCHIVE_RETRIEVAL
  }
  case object InventoryRetrieval extends zio.aws.glacier.model.ActionCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.ActionCode =
      software.amazon.awssdk.services.glacier.model.ActionCode.INVENTORY_RETRIEVAL
  }
  case object Select extends zio.aws.glacier.model.ActionCode {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.ActionCode =
      software.amazon.awssdk.services.glacier.model.ActionCode.SELECT
  }
}
