package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CSVInput(
    fileHeaderInfo: Option[zio.aws.glacier.model.FileHeaderInfo] = None,
    comments: Option[String] = None,
    quoteEscapeCharacter: Option[String] = None,
    recordDelimiter: Option[String] = None,
    fieldDelimiter: Option[String] = None,
    quoteCharacter: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CSVInput = {
    import CSVInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CSVInput
      .builder()
      .optionallyWith(fileHeaderInfo.map(value => value.unwrap))(
        _.fileHeaderInfo
      )
      .optionallyWith(comments.map(value => value: java.lang.String))(
        _.comments
      )
      .optionallyWith(
        quoteEscapeCharacter.map(value => value: java.lang.String)
      )(_.quoteEscapeCharacter)
      .optionallyWith(recordDelimiter.map(value => value: java.lang.String))(
        _.recordDelimiter
      )
      .optionallyWith(fieldDelimiter.map(value => value: java.lang.String))(
        _.fieldDelimiter
      )
      .optionallyWith(quoteCharacter.map(value => value: java.lang.String))(
        _.quoteCharacter
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.CSVInput.ReadOnly =
    zio.aws.glacier.model.CSVInput.wrap(buildAwsValue())
}
object CSVInput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.glacier.model.CSVInput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CSVInput =
      zio.aws.glacier.model.CSVInput(
        fileHeaderInfo.map(value => value),
        comments.map(value => value),
        quoteEscapeCharacter.map(value => value),
        recordDelimiter.map(value => value),
        fieldDelimiter.map(value => value),
        quoteCharacter.map(value => value)
      )
    def fileHeaderInfo: Option[zio.aws.glacier.model.FileHeaderInfo]
    def comments: Option[String]
    def quoteEscapeCharacter: Option[String]
    def recordDelimiter: Option[String]
    def fieldDelimiter: Option[String]
    def quoteCharacter: Option[String]
    def getFileHeaderInfo
        : ZIO[Any, AwsError, zio.aws.glacier.model.FileHeaderInfo] =
      AwsError.unwrapOptionField("fileHeaderInfo", fileHeaderInfo)
    def getComments: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comments", comments)
    def getQuoteEscapeCharacter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("quoteEscapeCharacter", quoteEscapeCharacter)
    def getRecordDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiter)
    def getFieldDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fieldDelimiter", fieldDelimiter)
    def getQuoteCharacter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("quoteCharacter", quoteCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CSVInput
  ) extends zio.aws.glacier.model.CSVInput.ReadOnly {
    override val fileHeaderInfo: Option[zio.aws.glacier.model.FileHeaderInfo] =
      scala
        .Option(impl.fileHeaderInfo())
        .map(value => zio.aws.glacier.model.FileHeaderInfo.wrap(value))
    override val comments: Option[String] =
      scala.Option(impl.comments()).map(value => value: String)
    override val quoteEscapeCharacter: Option[String] =
      scala.Option(impl.quoteEscapeCharacter()).map(value => value: String)
    override val recordDelimiter: Option[String] =
      scala.Option(impl.recordDelimiter()).map(value => value: String)
    override val fieldDelimiter: Option[String] =
      scala.Option(impl.fieldDelimiter()).map(value => value: String)
    override val quoteCharacter: Option[String] =
      scala.Option(impl.quoteCharacter()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CSVInput
  ): zio.aws.glacier.model.CSVInput.ReadOnly = new Wrapper(impl)
}
