package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CSVOutput(
    quoteFields: Option[zio.aws.glacier.model.QuoteFields] = None,
    quoteEscapeCharacter: Option[String] = None,
    recordDelimiter: Option[String] = None,
    fieldDelimiter: Option[String] = None,
    quoteCharacter: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CSVOutput = {
    import CSVOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CSVOutput
      .builder()
      .optionallyWith(quoteFields.map(value => value.unwrap))(_.quoteFields)
      .optionallyWith(
        quoteEscapeCharacter.map(value => value: java.lang.String)
      )(_.quoteEscapeCharacter)
      .optionallyWith(recordDelimiter.map(value => value: java.lang.String))(
        _.recordDelimiter
      )
      .optionallyWith(fieldDelimiter.map(value => value: java.lang.String))(
        _.fieldDelimiter
      )
      .optionallyWith(quoteCharacter.map(value => value: java.lang.String))(
        _.quoteCharacter
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.CSVOutput.ReadOnly =
    zio.aws.glacier.model.CSVOutput.wrap(buildAwsValue())
}
object CSVOutput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.glacier.model.CSVOutput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CSVOutput =
      zio.aws.glacier.model.CSVOutput(
        quoteFields.map(value => value),
        quoteEscapeCharacter.map(value => value),
        recordDelimiter.map(value => value),
        fieldDelimiter.map(value => value),
        quoteCharacter.map(value => value)
      )
    def quoteFields: Option[zio.aws.glacier.model.QuoteFields]
    def quoteEscapeCharacter: Option[String]
    def recordDelimiter: Option[String]
    def fieldDelimiter: Option[String]
    def quoteCharacter: Option[String]
    def getQuoteFields: ZIO[Any, AwsError, zio.aws.glacier.model.QuoteFields] =
      AwsError.unwrapOptionField("quoteFields", quoteFields)
    def getQuoteEscapeCharacter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("quoteEscapeCharacter", quoteEscapeCharacter)
    def getRecordDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiter)
    def getFieldDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fieldDelimiter", fieldDelimiter)
    def getQuoteCharacter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("quoteCharacter", quoteCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CSVOutput
  ) extends zio.aws.glacier.model.CSVOutput.ReadOnly {
    override val quoteFields: Option[zio.aws.glacier.model.QuoteFields] = scala
      .Option(impl.quoteFields())
      .map(value => zio.aws.glacier.model.QuoteFields.wrap(value))
    override val quoteEscapeCharacter: Option[String] =
      scala.Option(impl.quoteEscapeCharacter()).map(value => value: String)
    override val recordDelimiter: Option[String] =
      scala.Option(impl.recordDelimiter()).map(value => value: String)
    override val fieldDelimiter: Option[String] =
      scala.Option(impl.fieldDelimiter()).map(value => value: String)
    override val quoteCharacter: Option[String] =
      scala.Option(impl.quoteCharacter()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CSVOutput
  ): zio.aws.glacier.model.CSVOutput.ReadOnly = new Wrapper(impl)
}
