package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompleteMultipartUploadRequest(
    accountId: String,
    vaultName: String,
    uploadId: String,
    archiveSize: Option[String] = None,
    checksum: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest = {
    import CompleteMultipartUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .uploadId(uploadId: java.lang.String)
      .optionallyWith(archiveSize.map(value => value: java.lang.String))(
        _.archiveSize
      )
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.CompleteMultipartUploadRequest.ReadOnly =
    zio.aws.glacier.model.CompleteMultipartUploadRequest.wrap(buildAwsValue())
}
object CompleteMultipartUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CompleteMultipartUploadRequest =
      zio.aws.glacier.model.CompleteMultipartUploadRequest(
        accountId,
        vaultName,
        uploadId,
        archiveSize.map(value => value),
        checksum.map(value => value)
      )
    def accountId: String
    def vaultName: String
    def uploadId: String
    def archiveSize: Option[String]
    def checksum: Option[String]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getUploadId: ZIO[Any, Nothing, String] = ZIO.succeed(uploadId)
    def getArchiveSize: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveSize", archiveSize)
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest
  ) extends zio.aws.glacier.model.CompleteMultipartUploadRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val uploadId: String = impl.uploadId(): String
    override val archiveSize: Option[String] =
      scala.Option(impl.archiveSize()).map(value => value: String)
    override val checksum: Option[String] =
      scala.Option(impl.checksum()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadRequest
  ): zio.aws.glacier.model.CompleteMultipartUploadRequest.ReadOnly =
    new Wrapper(impl)
}
