package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompleteMultipartUploadResponse(
    location: Option[String] = None,
    checksum: Option[String] = None,
    archiveId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse = {
    import CompleteMultipartUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .optionallyWith(archiveId.map(value => value: java.lang.String))(
        _.archiveId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly =
    zio.aws.glacier.model.CompleteMultipartUploadResponse.wrap(buildAwsValue())
}
object CompleteMultipartUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CompleteMultipartUploadResponse =
      zio.aws.glacier.model.CompleteMultipartUploadResponse(
        location.map(value => value),
        checksum.map(value => value),
        archiveId.map(value => value)
      )
    def location: Option[String]
    def checksum: Option[String]
    def archiveId: Option[String]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getArchiveId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveId", archiveId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse
  ) extends zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly {
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
    override val checksum: Option[String] =
      scala.Option(impl.checksum()).map(value => value: String)
    override val archiveId: Option[String] =
      scala.Option(impl.archiveId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CompleteMultipartUploadResponse
  ): zio.aws.glacier.model.CompleteMultipartUploadResponse.ReadOnly =
    new Wrapper(impl)
}
