package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateVaultRequest(accountId: String, vaultName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CreateVaultRequest = {
    import CreateVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CreateVaultRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.CreateVaultRequest.ReadOnly =
    zio.aws.glacier.model.CreateVaultRequest.wrap(buildAwsValue())
}
object CreateVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.CreateVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CreateVaultRequest =
      zio.aws.glacier.model.CreateVaultRequest(accountId, vaultName)
    def accountId: String
    def vaultName: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CreateVaultRequest
  ) extends zio.aws.glacier.model.CreateVaultRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CreateVaultRequest
  ): zio.aws.glacier.model.CreateVaultRequest.ReadOnly = new Wrapper(impl)
}
