package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVaultResponse(location: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.CreateVaultResponse = {
    import CreateVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.CreateVaultResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.CreateVaultResponse.ReadOnly =
    zio.aws.glacier.model.CreateVaultResponse.wrap(buildAwsValue())
}
object CreateVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.CreateVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.CreateVaultResponse =
      zio.aws.glacier.model.CreateVaultResponse(location.map(value => value))
    def location: Option[String]
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.CreateVaultResponse
  ) extends zio.aws.glacier.model.CreateVaultResponse.ReadOnly {
    override val location: Option[String] =
      scala.Option(impl.location()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.CreateVaultResponse
  ): zio.aws.glacier.model.CreateVaultResponse.ReadOnly = new Wrapper(impl)
}
