package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.NullableLong
import scala.jdk.CollectionConverters._
final case class DataRetrievalRule(
    strategy: Option[String] = None,
    bytesPerHour: Option[NullableLong] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DataRetrievalRule = {
    import DataRetrievalRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DataRetrievalRule
      .builder()
      .optionallyWith(strategy.map(value => value: java.lang.String))(
        _.strategy
      )
      .optionallyWith(bytesPerHour.map(value => value: java.lang.Long))(
        _.bytesPerHour
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DataRetrievalRule.ReadOnly =
    zio.aws.glacier.model.DataRetrievalRule.wrap(buildAwsValue())
}
object DataRetrievalRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DataRetrievalRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DataRetrievalRule =
      zio.aws.glacier.model.DataRetrievalRule(
        strategy.map(value => value),
        bytesPerHour.map(value => value)
      )
    def strategy: Option[String]
    def bytesPerHour: Option[NullableLong]
    def getStrategy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("strategy", strategy)
    def getBytesPerHour: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("bytesPerHour", bytesPerHour)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DataRetrievalRule
  ) extends zio.aws.glacier.model.DataRetrievalRule.ReadOnly {
    override val strategy: Option[String] =
      scala.Option(impl.strategy()).map(value => value: String)
    override val bytesPerHour: Option[NullableLong] =
      scala.Option(impl.bytesPerHour()).map(value => value: NullableLong)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DataRetrievalRule
  ): zio.aws.glacier.model.DataRetrievalRule.ReadOnly = new Wrapper(impl)
}
