package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.Size
import scala.jdk.CollectionConverters._
final case class DescribeJobResponse(
    jobId: Option[String] = None,
    jobDescription: Option[String] = None,
    action: Option[zio.aws.glacier.model.ActionCode] = None,
    archiveId: Option[String] = None,
    vaultARN: Option[String] = None,
    creationDate: Option[String] = None,
    completed: Option[Boolean] = None,
    statusCode: Option[zio.aws.glacier.model.StatusCode] = None,
    statusMessage: Option[String] = None,
    archiveSizeInBytes: Option[Size] = None,
    inventorySizeInBytes: Option[Size] = None,
    snsTopic: Option[String] = None,
    completionDate: Option[String] = None,
    sha256TreeHash: Option[String] = None,
    archiveSHA256TreeHash: Option[String] = None,
    retrievalByteRange: Option[String] = None,
    tier: Option[String] = None,
    inventoryRetrievalParameters: Option[
      zio.aws.glacier.model.InventoryRetrievalJobDescription
    ] = None,
    jobOutputPath: Option[String] = None,
    selectParameters: Option[zio.aws.glacier.model.SelectParameters] = None,
    outputLocation: Option[zio.aws.glacier.model.OutputLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DescribeJobResponse = {
    import DescribeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DescribeJobResponse
      .builder()
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(jobDescription.map(value => value: java.lang.String))(
        _.jobDescription
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(archiveId.map(value => value: java.lang.String))(
        _.archiveId
      )
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(completed.map(value => value: java.lang.Boolean))(
        _.completed
      )
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        archiveSizeInBytes.map(value => Size.unwrap(value): java.lang.Long)
      )(_.archiveSizeInBytes)
      .optionallyWith(
        inventorySizeInBytes.map(value => Size.unwrap(value): java.lang.Long)
      )(_.inventorySizeInBytes)
      .optionallyWith(snsTopic.map(value => value: java.lang.String))(
        _.snsTopic
      )
      .optionallyWith(completionDate.map(value => value: java.lang.String))(
        _.completionDate
      )
      .optionallyWith(sha256TreeHash.map(value => value: java.lang.String))(
        _.sha256TreeHash
      )
      .optionallyWith(
        archiveSHA256TreeHash.map(value => value: java.lang.String)
      )(_.archiveSHA256TreeHash)
      .optionallyWith(retrievalByteRange.map(value => value: java.lang.String))(
        _.retrievalByteRange
      )
      .optionallyWith(tier.map(value => value: java.lang.String))(_.tier)
      .optionallyWith(
        inventoryRetrievalParameters.map(value => value.buildAwsValue())
      )(_.inventoryRetrievalParameters)
      .optionallyWith(jobOutputPath.map(value => value: java.lang.String))(
        _.jobOutputPath
      )
      .optionallyWith(selectParameters.map(value => value.buildAwsValue()))(
        _.selectParameters
      )
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DescribeJobResponse.ReadOnly =
    zio.aws.glacier.model.DescribeJobResponse.wrap(buildAwsValue())
}
object DescribeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DescribeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DescribeJobResponse =
      zio.aws.glacier.model.DescribeJobResponse(
        jobId.map(value => value),
        jobDescription.map(value => value),
        action.map(value => value),
        archiveId.map(value => value),
        vaultARN.map(value => value),
        creationDate.map(value => value),
        completed.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        archiveSizeInBytes.map(value => value),
        inventorySizeInBytes.map(value => value),
        snsTopic.map(value => value),
        completionDate.map(value => value),
        sha256TreeHash.map(value => value),
        archiveSHA256TreeHash.map(value => value),
        retrievalByteRange.map(value => value),
        tier.map(value => value),
        inventoryRetrievalParameters.map(value => value.asEditable),
        jobOutputPath.map(value => value),
        selectParameters.map(value => value.asEditable),
        outputLocation.map(value => value.asEditable)
      )
    def jobId: Option[String]
    def jobDescription: Option[String]
    def action: Option[zio.aws.glacier.model.ActionCode]
    def archiveId: Option[String]
    def vaultARN: Option[String]
    def creationDate: Option[String]
    def completed: Option[Boolean]
    def statusCode: Option[zio.aws.glacier.model.StatusCode]
    def statusMessage: Option[String]
    def archiveSizeInBytes: Option[Size]
    def inventorySizeInBytes: Option[Size]
    def snsTopic: Option[String]
    def completionDate: Option[String]
    def sha256TreeHash: Option[String]
    def archiveSHA256TreeHash: Option[String]
    def retrievalByteRange: Option[String]
    def tier: Option[String]
    def inventoryRetrievalParameters: Option[
      zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly
    ]
    def jobOutputPath: Option[String]
    def selectParameters
        : Option[zio.aws.glacier.model.SelectParameters.ReadOnly]
    def outputLocation: Option[zio.aws.glacier.model.OutputLocation.ReadOnly]
    def getJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobDescription", jobDescription)
    def getAction: ZIO[Any, AwsError, zio.aws.glacier.model.ActionCode] =
      AwsError.unwrapOptionField("action", action)
    def getArchiveId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveId", archiveId)
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompleted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("completed", completed)
    def getStatusCode: ZIO[Any, AwsError, zio.aws.glacier.model.StatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getArchiveSizeInBytes: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("archiveSizeInBytes", archiveSizeInBytes)
    def getInventorySizeInBytes: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("inventorySizeInBytes", inventorySizeInBytes)
    def getSnsTopic: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getCompletionDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getSha256TreeHash: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sha256TreeHash", sha256TreeHash)
    def getArchiveSHA256TreeHash: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveSHA256TreeHash", archiveSHA256TreeHash)
    def getRetrievalByteRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("retrievalByteRange", retrievalByteRange)
    def getTier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tier", tier)
    def getInventoryRetrievalParameters: ZIO[
      Any,
      AwsError,
      zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inventoryRetrievalParameters",
      inventoryRetrievalParameters
    )
    def getJobOutputPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobOutputPath", jobOutputPath)
    def getSelectParameters
        : ZIO[Any, AwsError, zio.aws.glacier.model.SelectParameters.ReadOnly] =
      AwsError.unwrapOptionField("selectParameters", selectParameters)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.glacier.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DescribeJobResponse
  ) extends zio.aws.glacier.model.DescribeJobResponse.ReadOnly {
    override val jobId: Option[String] =
      scala.Option(impl.jobId()).map(value => value: String)
    override val jobDescription: Option[String] =
      scala.Option(impl.jobDescription()).map(value => value: String)
    override val action: Option[zio.aws.glacier.model.ActionCode] = scala
      .Option(impl.action())
      .map(value => zio.aws.glacier.model.ActionCode.wrap(value))
    override val archiveId: Option[String] =
      scala.Option(impl.archiveId()).map(value => value: String)
    override val vaultARN: Option[String] =
      scala.Option(impl.vaultARN()).map(value => value: String)
    override val creationDate: Option[String] =
      scala.Option(impl.creationDate()).map(value => value: String)
    override val completed: Option[Boolean] =
      scala.Option(impl.completed()).map(value => value: Boolean)
    override val statusCode: Option[zio.aws.glacier.model.StatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.glacier.model.StatusCode.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val archiveSizeInBytes: Option[Size] = scala
      .Option(impl.archiveSizeInBytes())
      .map(value => zio.aws.glacier.model.primitives.Size(value))
    override val inventorySizeInBytes: Option[Size] = scala
      .Option(impl.inventorySizeInBytes())
      .map(value => zio.aws.glacier.model.primitives.Size(value))
    override val snsTopic: Option[String] =
      scala.Option(impl.snsTopic()).map(value => value: String)
    override val completionDate: Option[String] =
      scala.Option(impl.completionDate()).map(value => value: String)
    override val sha256TreeHash: Option[String] =
      scala.Option(impl.sha256TreeHash()).map(value => value: String)
    override val archiveSHA256TreeHash: Option[String] =
      scala.Option(impl.archiveSHA256TreeHash()).map(value => value: String)
    override val retrievalByteRange: Option[String] =
      scala.Option(impl.retrievalByteRange()).map(value => value: String)
    override val tier: Option[String] =
      scala.Option(impl.tier()).map(value => value: String)
    override val inventoryRetrievalParameters: Option[
      zio.aws.glacier.model.InventoryRetrievalJobDescription.ReadOnly
    ] = scala
      .Option(impl.inventoryRetrievalParameters())
      .map(value =>
        zio.aws.glacier.model.InventoryRetrievalJobDescription.wrap(value)
      )
    override val jobOutputPath: Option[String] =
      scala.Option(impl.jobOutputPath()).map(value => value: String)
    override val selectParameters
        : Option[zio.aws.glacier.model.SelectParameters.ReadOnly] = scala
      .Option(impl.selectParameters())
      .map(value => zio.aws.glacier.model.SelectParameters.wrap(value))
    override val outputLocation
        : Option[zio.aws.glacier.model.OutputLocation.ReadOnly] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.glacier.model.OutputLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DescribeJobResponse
  ): zio.aws.glacier.model.DescribeJobResponse.ReadOnly = new Wrapper(impl)
}
