package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVaultOutput(
    vaultARN: Option[String] = None,
    vaultName: Option[String] = None,
    creationDate: Option[String] = None,
    lastInventoryDate: Option[String] = None,
    numberOfArchives: Option[Long] = None,
    sizeInBytes: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.DescribeVaultOutput = {
    import DescribeVaultOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.DescribeVaultOutput
      .builder()
      .optionallyWith(vaultARN.map(value => value: java.lang.String))(
        _.vaultARN
      )
      .optionallyWith(vaultName.map(value => value: java.lang.String))(
        _.vaultName
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(lastInventoryDate.map(value => value: java.lang.String))(
        _.lastInventoryDate
      )
      .optionallyWith(numberOfArchives.map(value => value: java.lang.Long))(
        _.numberOfArchives
      )
      .optionallyWith(sizeInBytes.map(value => value: java.lang.Long))(
        _.sizeInBytes
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.DescribeVaultOutput.ReadOnly =
    zio.aws.glacier.model.DescribeVaultOutput.wrap(buildAwsValue())
}
object DescribeVaultOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.DescribeVaultOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.DescribeVaultOutput =
      zio.aws.glacier.model.DescribeVaultOutput(
        vaultARN.map(value => value),
        vaultName.map(value => value),
        creationDate.map(value => value),
        lastInventoryDate.map(value => value),
        numberOfArchives.map(value => value),
        sizeInBytes.map(value => value)
      )
    def vaultARN: Option[String]
    def vaultName: Option[String]
    def creationDate: Option[String]
    def lastInventoryDate: Option[String]
    def numberOfArchives: Option[Long]
    def sizeInBytes: Option[Long]
    def getVaultARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultARN", vaultARN)
    def getVaultName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vaultName", vaultName)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastInventoryDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastInventoryDate", lastInventoryDate)
    def getNumberOfArchives: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("numberOfArchives", numberOfArchives)
    def getSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.DescribeVaultOutput
  ) extends zio.aws.glacier.model.DescribeVaultOutput.ReadOnly {
    override val vaultARN: Option[String] =
      scala.Option(impl.vaultARN()).map(value => value: String)
    override val vaultName: Option[String] =
      scala.Option(impl.vaultName()).map(value => value: String)
    override val creationDate: Option[String] =
      scala.Option(impl.creationDate()).map(value => value: String)
    override val lastInventoryDate: Option[String] =
      scala.Option(impl.lastInventoryDate()).map(value => value: String)
    override val numberOfArchives: Option[Long] =
      scala.Option(impl.numberOfArchives()).map(value => value: Long)
    override val sizeInBytes: Option[Long] =
      scala.Option(impl.sizeInBytes()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.DescribeVaultOutput
  ): zio.aws.glacier.model.DescribeVaultOutput.ReadOnly = new Wrapper(impl)
}
