package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Encryption(
    encryptionType: Option[zio.aws.glacier.model.EncryptionType] = None,
    kmsKeyId: Option[String] = None,
    kmsContext: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.Encryption = {
    import Encryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.Encryption
      .builder()
      .optionallyWith(encryptionType.map(value => value.unwrap))(
        _.encryptionType
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(kmsContext.map(value => value: java.lang.String))(
        _.kmsContext
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.Encryption.ReadOnly =
    zio.aws.glacier.model.Encryption.wrap(buildAwsValue())
}
object Encryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.Encryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.Encryption =
      zio.aws.glacier.model.Encryption(
        encryptionType.map(value => value),
        kmsKeyId.map(value => value),
        kmsContext.map(value => value)
      )
    def encryptionType: Option[zio.aws.glacier.model.EncryptionType]
    def kmsKeyId: Option[String]
    def kmsContext: Option[String]
    def getEncryptionType
        : ZIO[Any, AwsError, zio.aws.glacier.model.EncryptionType] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKmsContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsContext", kmsContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.Encryption
  ) extends zio.aws.glacier.model.Encryption.ReadOnly {
    override val encryptionType: Option[zio.aws.glacier.model.EncryptionType] =
      scala
        .Option(impl.encryptionType())
        .map(value => zio.aws.glacier.model.EncryptionType.wrap(value))
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val kmsContext: Option[String] =
      scala.Option(impl.kmsContext()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.Encryption
  ): zio.aws.glacier.model.Encryption.ReadOnly = new Wrapper(impl)
}
