package zio.aws.glacier.model
import scala.jdk.CollectionConverters._
sealed trait ExpressionType {
  def unwrap: software.amazon.awssdk.services.glacier.model.ExpressionType
}
object ExpressionType {
  def wrap(
      value: software.amazon.awssdk.services.glacier.model.ExpressionType
  ): zio.aws.glacier.model.ExpressionType = value match {
    case software.amazon.awssdk.services.glacier.model.ExpressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.glacier.model.ExpressionType.SQL =>
      val r = SQL
      r
  }
  case object unknownToSdkVersion extends zio.aws.glacier.model.ExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.ExpressionType =
      software.amazon.awssdk.services.glacier.model.ExpressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SQL extends zio.aws.glacier.model.ExpressionType {
    override def unwrap
        : software.amazon.awssdk.services.glacier.model.ExpressionType =
      software.amazon.awssdk.services.glacier.model.ExpressionType.SQL
  }
}
