package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDataRetrievalPolicyRequest(accountId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest = {
    import GetDataRetrievalPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetDataRetrievalPolicyRequest.ReadOnly =
    zio.aws.glacier.model.GetDataRetrievalPolicyRequest.wrap(buildAwsValue())
}
object GetDataRetrievalPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetDataRetrievalPolicyRequest =
      zio.aws.glacier.model.GetDataRetrievalPolicyRequest(accountId)
    def accountId: String
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest
  ) extends zio.aws.glacier.model.GetDataRetrievalPolicyRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetDataRetrievalPolicyRequest
  ): zio.aws.glacier.model.GetDataRetrievalPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
