package zio.aws.glacier.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetJobOutputRequest(
    accountId: String,
    vaultName: String,
    jobId: String,
    range: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetJobOutputRequest = {
    import GetJobOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetJobOutputRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .vaultName(vaultName: java.lang.String)
      .jobId(jobId: java.lang.String)
      .optionallyWith(range.map(value => value: java.lang.String))(_.range)
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetJobOutputRequest.ReadOnly =
    zio.aws.glacier.model.GetJobOutputRequest.wrap(buildAwsValue())
}
object GetJobOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetJobOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetJobOutputRequest =
      zio.aws.glacier.model.GetJobOutputRequest(
        accountId,
        vaultName,
        jobId,
        range.map(value => value)
      )
    def accountId: String
    def vaultName: String
    def jobId: String
    def range: Option[String]
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getVaultName: ZIO[Any, Nothing, String] = ZIO.succeed(vaultName)
    def getJobId: ZIO[Any, Nothing, String] = ZIO.succeed(jobId)
    def getRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("range", range)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetJobOutputRequest
  ) extends zio.aws.glacier.model.GetJobOutputRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val vaultName: String = impl.vaultName(): String
    override val jobId: String = impl.jobId(): String
    override val range: Option[String] =
      scala.Option(impl.range()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetJobOutputRequest
  ): zio.aws.glacier.model.GetJobOutputRequest.ReadOnly = new Wrapper(impl)
}
