package zio.aws.glacier.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.glacier.model.primitives.Httpstatus
import scala.jdk.CollectionConverters._
final case class GetJobOutputResponse(
    checksum: Option[String] = None,
    status: Option[Httpstatus] = None,
    contentRange: Option[String] = None,
    acceptRanges: Option[String] = None,
    contentType: Option[String] = None,
    archiveDescription: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.glacier.model.GetJobOutputResponse = {
    import GetJobOutputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
      .builder()
      .optionallyWith(checksum.map(value => value: java.lang.String))(
        _.checksum
      )
      .optionallyWith(status.map(value => Httpstatus.unwrap(value): Integer))(
        _.status
      )
      .optionallyWith(contentRange.map(value => value: java.lang.String))(
        _.contentRange
      )
      .optionallyWith(acceptRanges.map(value => value: java.lang.String))(
        _.acceptRanges
      )
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(archiveDescription.map(value => value: java.lang.String))(
        _.archiveDescription
      )
      .build()
  }
  def asReadOnly: zio.aws.glacier.model.GetJobOutputResponse.ReadOnly =
    zio.aws.glacier.model.GetJobOutputResponse.wrap(buildAwsValue())
}
object GetJobOutputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.glacier.model.GetJobOutputResponse =
      zio.aws.glacier.model.GetJobOutputResponse(
        checksum.map(value => value),
        status.map(value => value),
        contentRange.map(value => value),
        acceptRanges.map(value => value),
        contentType.map(value => value),
        archiveDescription.map(value => value)
      )
    def checksum: Option[String]
    def status: Option[Httpstatus]
    def contentRange: Option[String]
    def acceptRanges: Option[String]
    def contentType: Option[String]
    def archiveDescription: Option[String]
    def getChecksum: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getStatus: ZIO[Any, AwsError, Httpstatus] =
      AwsError.unwrapOptionField("status", status)
    def getContentRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentRange", contentRange)
    def getAcceptRanges: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acceptRanges", acceptRanges)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getArchiveDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("archiveDescription", archiveDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
  ) extends zio.aws.glacier.model.GetJobOutputResponse.ReadOnly {
    override val checksum: Option[String] =
      scala.Option(impl.checksum()).map(value => value: String)
    override val status: Option[Httpstatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.glacier.model.primitives.Httpstatus(value))
    override val contentRange: Option[String] =
      scala.Option(impl.contentRange()).map(value => value: String)
    override val acceptRanges: Option[String] =
      scala.Option(impl.acceptRanges()).map(value => value: String)
    override val contentType: Option[String] =
      scala.Option(impl.contentType()).map(value => value: String)
    override val archiveDescription: Option[String] =
      scala.Option(impl.archiveDescription()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.glacier.model.GetJobOutputResponse
  ): zio.aws.glacier.model.GetJobOutputResponse.ReadOnly = new Wrapper(impl)
}
